#include "mbed.h"

#ifndef MATRIXSPI_H
#define MATRIXSPI_H

#define LOW 0
#define HIGH 1
#define MHZ 1000000

class MatrixSPI
{

public:
    const static int NOOP =         0x00;
    const static int digit0 =       0x01;
    const static int digit1 =       0x02;
    const static int digit2 =       0x03;
    const static int digit3 =       0x04;
    const static int digit4 =       0x05;
    const static int digit5 =       0x06;
    const static int digit6 =       0x07;
    const static int digit7 =       0x08;
    const static int decodeMode =   0x09;
    const static int intensity =    0x0a;
    const static int scanLimit =    0x0b;
    const static int shutdown =     0x0c;
    const static int displayTest =  0x0f;

    MatrixSPI(PinName data_input = dp2, PinName clock = dp6, PinName loadcs = dp24)
    :max72_spi(data_input, NC, clock), load(loadcs)
    #warning ako ne radi- NC zamijeniti sa dp1
    { setup();  }
    
    void setup ();

    void sendSingle(int reg, int data);
    void sendCol(int col, int data);
    
    void turnON(){
        sendSingle(shutdown, 0x01);    // not in shutdown mode
    }
    
    void turnOFF(){
        sendSingle(shutdown, 0x00);
    }
    
private:
    SPI max72_spi;
    DigitalOut load;
};

#endif // MATRIXSPI_H
