#include "MatrixSPI.h"

 void MatrixSPI::setup () {
        // initiation of the max 7219
        // SPI setup: 8 bits, mode 0
        max72_spi.format(8, 0);
        
        // going by the datasheet, min clk is 100ns so theoretically 10MHz should work...
        // max72_spi.frequency(10*MHZ);
        
        sendSingle(scanLimit, 0x07);
        sendSingle(decodeMode, 0x00);  // using an led matrix (not digits)
        sendSingle(shutdown, 0x01);    // not in shutdown mode
        sendSingle(displayTest, 0x00); // no display test
        for (int e=1; e<=8; e++) {    // empty registers, turn all LEDs off
            sendSingle(e,0);
        }
        sendSingle(intensity, 0x0f & 0x0f);    // the first 0x0f is the value you can set
                                           // range: 0x00 to 0x0f
}
void MatrixSPI::sendSingle(int reg, int data) {
        load = LOW;            // begin
        max72_spi.write(reg);  // specify register
        max72_spi.write(data);  // put data
        load = HIGH;           // make sure data is loaded (on rising edge of LOAD/CS)
    }
    
    void MatrixSPI::sendCol(int col, int data) {
        sendSingle(col + 1, data);
    }