# include "mbed.h"
# include "N5110.h"
# include <vector>
// Deklaracija LCD objekta
// N5110 lcd (VCC ,SCE ,RST ,D/C,MOSI ,SCLK , LED )
N5110 lcd (dp4 ,dp24 ,dp23 ,dp25 ,dp2 ,dp6 , dp18 );
// Digitalni izlaz za deaktivaciju LED buffera
//DigitalOut enable ( dp14 );

AnalogIn VRx ( dp11 );
AnalogIn VRy ( dp10 );

DigitalIn SW( dp17 );// Taster sa dzojstika
DigitalIn taster1(dp1);




bool taster_jedan(){
    bool pricinut = false;
    int i=0;
    while(taster1) i++;
    if(i>5000) pricinut=true;
    return pricinut;
}

struct Koordinata {
    int x,y;
    Koordinata(int x, int y) : x(x), y(y) {}
    
};

void setCursor(int x, int y, std::vector<Koordinata> &v) {
    if(x<83 && y<47 && x>0 && y>0){
    lcd.clear();
    for(int i(0); i<v.size(); i++) {
    lcd.setXYAddress(0,0);
    lcd.setPixel(v[i].x,v[i].y);
    }
    lcd.setXYAddress(0,0);
    lcd.setPixel(x,y);
    lcd.setPixel(x+1,y);
    lcd.setPixel(x-1,y);
    lcd.setPixel(x,y+1);
    lcd.setPixel(x,y-1);
    lcd.refresh();
    }
}

   vector<Koordinata> tacke; 
void regulisiTaster(int x, int y) {
    for(int i(0); i<1000; i++){
    if(taster_jedan()) {tacke = vector<Koordinata>();
    return;}
    }
    tacke.push_back(Koordinata(x, y));  
}

int main () {
    lcd.setXYAddress(0,0);
    lcd.init ();// inicijalizacija displeja
    setCursor(42,24,tacke);

while (1) {
    int x = VRx*83, y = VRy*47;
    if(taster_jedan()) regulisiTaster(x,y);
    setCursor(x, y, tacke);

}
}