#include "mbed.h"
#include "N5110.h"

AnalogIn VRx(dp11);
AnalogIn VRy(dp10); // osni ulazi dzojstika
DigitalIn SW(dp9); // taster ulaz dzojstika

N5110 lcd(dp4, dp24, dp23, dp25, dp2, dp6, dp18);   //LCD izlaz

DigitalOut enable(dp14);   // deaktivacija LEDova (aktivni u nuli)

Timer t;

void kursor(int x, int y)
{
    for(int i=x; i<=x+5; i++)
     for(int j=y; j<=y+5; j++)
        {
            lcd.setPixel(i,j);
            lcd.refresh();
        }
}


int main() {

    int x=0, y=0; // pocetne koordinate
    int ekran[84][48];
    
    for(int i=0;i<84;i++)
        for(int j=0;j<48;j++)
            ekran[i][j]=0; // inicijalizacija matrice ekrana
            
    SW.mode(PullUp); // aktivacija pull-up otpornika (taster)
    enable=1;
    
    t.start();
    lcd.init();     // inicijalizacija ekrana
    lcd.setXYAddress(0,0);
    lcd.setPixel(1,0);
    lcd.refresh();
    lcd.setPixel(0,1);
    lcd.refresh();
    
    kursor(x,y);
    while(1){
       if(VRx < 1.0/3.0)
       {
           if(x>0){ // da izbrise
            for(int i=x; i<=x+5; i++)
             for(int j=y; j<=y+5; j++)
                {
                    lcd.clearPixel(i,j);
                    lcd.refresh();
                }
            }
            x=x-1;
            kursor(x,y);
        }
       else if(VRx > 2.0/3.0)
       {
           if(x<84){
            for(int i=x; i<=x+5; i++)
                 for(int j=y; j<=y+5; j++)
                    {
                        lcd.clearPixel(i,j);
                        lcd.refresh();
                    }
            }
        x=x+1;
        kursor(x,y);
        }
        
      /*if(VRy < 1.0/3.0)
      {
        if(y>0){
        for(int i=x; i<=x+5; i++)
                 for(int j=y; j<=y+5; j++)
                    {
                        lcd.clearPixel(i,j);
                        lcd.refresh();
                }
        y=y-1;
        kursor(x,y);
        }
      else if(VRy > 2.0/3.0)
      {
        if(y<48){
            for(int i=x; i<=x+5; i++)
                 for(int j=y; j<=y+5; j++)
                    {
                        lcd.clearPixel(i,j);
                        lcd.refresh();
                    }
        y=y-1;
        kursor(x,y);
        }
        
        }
        }*/
    }
}
  
        /*while(1)
        {
            if(SW==1 && t.read()==0) {t.start(); ekran[x][y]=1; lcd.setPixel(x,y);lcd.refresh();}
            else if(SW==1 && t.read()<0.5)
                {
                lcd.clear();
                if(x!=0) lcd.setPixel(x-1,y); lcd.refresh();
                if(x!=83) lcd.setPixel(x+1,y); lcd.refresh();
                if(y!=0) lcd.setPixel(x,y-1); lcd.refresh();
                if(y!=43) lcd.setPixel(x,y+1); lcd.refresh();
                
                for(int i=0;i<84;i++)
                    for(int j=0;j<48;j++)
                        ekran[i][j]=0;
                }               
            if(t.read()>0.5) {t.stop(); t.reset();}
            
            if(VRx<1.0/3.3 && x!=0)                 // micanje lijevo
            {
            x--;
            lcd.setPixel(x+1,y);
            lcd.refresh();
            if(ekran[x][y]==0) lcd.clearPixel(x,y);
            lcd.refresh();
            if(x!=0) lcd.setPixel(x-1,y);
            lcd.refresh();
            if(x!=82 && ekran[x+2][y]==0) lcd.clearPixel(x+2,y);
            lcd.refresh();
            
            if(y!=0)
                {
                lcd.setPixel(x,y-1);
                lcd.refresh();
                if(ekran[x+1][y-1]==0) lcd.clearPixel(x+1,y-1);
                lcd.refresh();         
                } 
                
            if(y!=47)
                {
                lcd.setPixel(x,y+1);
                lcd.refresh();    
                if(ekran[x+1][y+1]==0) lcd.clearPixel(x+1,y+1);
                lcd.refresh(); 
                }
            }

        else if(VRx>2.0/3.3 && x!=83)           // micanje desno
            {
            x++;
            lcd.setPixel(x-1,y);
            lcd.refresh();
            if(ekran[x][y]==0) lcd.clearPixel(x,y); lcd.refresh();
            if(x!=83) lcd.setPixel(x+1,y); lcd.refresh();
            if(x!=1 && ekran[x-2][y]==0) lcd.clearPixel(x-2,y); lcd.refresh();
            
            if(y!=0)
                {
                lcd.setPixel(x,y-1); lcd.refresh();
                if(ekran[x-1][y-1]==0) lcd.clearPixel(x-1,y-1); lcd.refresh();
                }
                
            if(y!=47)
                {
                lcd.setPixel(x,y+1); lcd.refresh();
                if(ekran[x-1][y+1]==0) lcd.clearPixel(x-1,y+1); lcd.refresh();
                }
            }
    
    
        if(VRy<1.0/3.3 && y!=47)                        // micanje dolje
            {
            y++;
            lcd.setPixel(x,y-1); lcd.refresh();
            if(ekran[x][y]==0) lcd.clearPixel(x,y); lcd.refresh();
            if(y!=47) lcd.setPixel(x,y+1); lcd.refresh();
            if(y!=1 && ekran[x][y-2]==0) lcd.clearPixel(x,y-2); lcd.refresh();
            
            if(x!=0)
                {
                lcd.setPixel(x-1,y); lcd.refresh();
                if(ekran[x-1][y-1]==0) lcd.clearPixel(x-1,y-1); lcd.refresh();
                }
                
            if(x!=83)
                {
                lcd.setPixel(x+1,y); lcd.refresh();
                if(ekran[x+1][y-1]==0) lcd.clearPixel(x+1,y-1); lcd.refresh();
                }
            }
        else if(VRy>2.0/3.3 && y!=0)            // micanje gore
            {
            y--;
            lcd.setPixel(x,y+1); lcd.refresh();
            if(ekran[x][y]==0) lcd.clearPixel(x,y); lcd.refresh();
            if(y!=0) lcd.setPixel(x,y-1); lcd.refresh();
            if(y!=46 && ekran[x][y+2]==0) lcd.clearPixel(x,y+2); lcd.refresh();
            if(x!=0)
                {
                lcd.setPixel(x-1,y); lcd.refresh();
                if(ekran[x-1][y+1]==0) lcd.clearPixel(x-1,y+1); lcd.refresh();
                } 
            if(x!=83)
                 {
                 lcd.setPixel(x+1,y); lcd.refresh();
                 if(ekran[x+1][y+1]==0) lcd.clearPixel(x+1,y+1); lcd.refresh();
                 }
            }     
        wait_ms(200);
       }
}*/