#include "mbed.h"
#include "N5110.h"
#include <vector>

//koordinate
int X = 0;
int Y = 0;

//lcd
N5110 lcd(dp4, dp24, dp23, dp25, dp2, dp6, dp18);
DigitalOut enable(dp14);

//dzojstik
AnalogIn VRx(dp11);
AnalogIn VRy(dp10);

struct Koordinate
{
    int x;int y;
    Koordinate(int a,int b){x=a;y=b;}
    };
vector<Koordinate> koordinate;

//LAFO CRTA CROSSHAIR U OBLIKU OBICNOG PLUSA
void drawCrosshair(int x, int y){
    
    int i = x - 3;
    int j = y;
    
    while( i <= x + 3){
            
        lcd.setPixel(i, j);
       
        i++;
    }  
    lcd.refresh();
    
    i = x;
    j = y - 3;
    
    while(j <= y + 3){
        
        lcd.setPixel(i, j);
        
        j++;
        
    }  
    lcd.refresh();
}


//brise crosshair na koordinatama

void clearCrosshair(int x, int y){
      
    int i = x - 3;
    int j = y;
    
    while( i <= x + 3){
            
        lcd.clearPixel(i, j);
       
        i++;
    }  
    lcd.refresh();
    
    i = x;
    j = y - 3;
    
    while(j <= y + 3){
        
        lcd.clearPixel(i, j);
        j++;
    }    
    for(int i=0;i<koordinate.size();i++)
    {
      lcd.setPixel(koordinate[i].x,koordinate[i].y);    
    }
    
    lcd.refresh();
}

//ako je dzojstik lijevo poMAKET

void LEFT(int &x, int &y){

    if(x > 0){
        
        clearCrosshair(x, y);
        x = x - 1;
        drawCrosshair(x, y);
        lcd.refresh();
    } 

}

//ako je desno poMAKET

void RIGHT(int &x, int &y){

    if(x < 84){
        
        clearCrosshair(x, y);
        x = x + 1;
        drawCrosshair(x, y);
        lcd.refresh();
    } 

}

void DOWN(int &x, int &y){
    
    if(y < 45){
    
        clearCrosshair(x, y);
        y = y + 1;// ili minus dont nouuuuuuuu
        drawCrosshair(x, y);
        lcd.refresh();
    }    

}

void UP(int &x, int &y){
    
    if(y > 0){
        
        clearCrosshair(x, y);
        y = y - 1;//ili plus dont nouuuuuuuuuuuu
        drawCrosshair(x, y);
        lcd.refresh();
    }
}
Timer t;
InterruptIn taster(dp1);
static int kliknut=1;
Timer t1;
void tacka()
{
 if(t.read_ms() > 400){ 
            if(kliknut%2!=0) {lcd.setPixel(X,Y); lcd.refresh(); kliknut++; koordinate.push_back(Koordinate(X,Y));}
        else{
            t1.reset();
            if(t1.read_ms()>400){
        lcd.clear();
        
        for(int i=0;i<koordinate.size();i++) koordinate.pop_back();
        
        lcd.refresh();
        
        }
        kliknut=1;
        
    }
    
    t.reset();
    
     }
}



int main() {
  
    enable = 1;
    t.start();
    t1.start();
    lcd.init();
    lcd.setXYAddress(X, Y);
    lcd.refresh();
    taster.rise(&tacka);
    taster.enable_irq();
    while(1){
        
        if(VRx < 1.0/3.0) LEFT(X,Y);
      else if(VRx > 2.0/3.0) RIGHT(X,Y);
 
      if(VRy < 1.0/3.0) UP(X,Y);
      else if(VRy > 2.0/3.0) DOWN(X,Y);
       
    }
    
  
}
