#include "mbed.h"

#define EYE_WAIT_TIME 10

Ticker tick1, tick2, tick3;
Timer timer;

BusOut segments(dp18, dp4, dp28, dp6, dp5, dp27, dp26);
BusOut digit(dp23, dp24, dp25);
DigitalOut decimal_point(dp17);

InterruptIn taster1(dp1);
InterruptIn taster2(dp2);

int digit_buffer[3] = {0, 0, 0};
unsigned int predefined_segments[19] = {0x01, 0x4f, 0x12, 0x06, 0x4c, 
                                0x24, 0x20, 0x0f, 0x00, 0x04,
                                0x08,0x60,0x31,0x42,0x30,0x38,
                                ~(0x01), 0x36, ~0};

void display_number() {
    float num = timer.read();
    unsigned const int digit_buffer[3] = {(int)(num / 10) % 10,(int)(num) % 10,(int)(num * 10) % 10};

    for(int i = 1; i <= 4; i = i * 2) {
        digit = ~i;
        segments = predefined_segments[ digit_buffer[i / 2] ];
        decimal_point = !(i == 2);
       
    }
}

void display_first() {
    __disable_irq();
    float num = timer.read();
    unsigned const int digit_buffer[3] = {
                    (int)(num / 10) % 10,
                    (int)(num) % 10,
                    (int)(num * 10) % 10
                    };
    int i = 1;
    digit = ~i;
    segments = predefined_segments[ digit_buffer[i / 2] ];
    decimal_point = !(i == 2);
    __enable_irq();
}

void display_second() {
    __disable_irq();
    float num = timer.read();
    unsigned const int digit_buffer[3] = {
                    (int)(num / 10) % 10,
                    (int)(num) % 10,
                    (int)(num * 10) % 10
                    };
    int i = 2;
    digit = ~i;
    segments = predefined_segments[ digit_buffer[i / 2] ];
    decimal_point = !(i == 2);
    __enable_irq();
}

void display_third() {
    __disable_irq();
    float num = timer.read();
    unsigned const int digit_buffer[3] = {
                    (int)(num / 10) % 10,
                    (int)(num) % 10,
                    (int)(num * 10) % 10
                    };
    int i = 4;
    digit = ~i;
    segments = predefined_segments[ digit_buffer[i / 2] ];
    decimal_point = !(i == 2);
    __enable_irq();
}

int i = 0;
void pause() {
    __disable_irq();
    (i++ % 2 == 0) ? timer.stop() : timer.start();   
    __enable_irq();   
}


void restart()
{
    timer.reset();

}
int main() {
   
   
    taster2.rise(&pause);
    taster1.rise(&restart);
    
    timer.start();
    display_first();
    display_second();
    display_third();
    tick1.attach(&display_first, .001);
    tick2.attach(&display_second, .002);
    tick3.attach(&display_third, .003);
    while(true);
    
    
}