#include "mbed.h"

int cifre[10]={0x40,0x79,0x24,0x30,0x19,0x12,0x02,0x078,0x0,0x10};
 
BusOut enable(dp23,dp24,dp25);
BusOut display(dp26, dp27, dp5, dp6, dp28, dp4, dp18);
DigitalOut point(dp17);

InterruptIn t1(dp1);
InterruptIn t2(dp2);
int cifra1(cifre[0]);
int cifra2(cifre[0]);
int cifra3(cifre[0]);
int izborCifre(3);
Timer timer1;
Ticker ticker1;
Ticker ticker2;
Timer debounce;
Timer debounce1;

bool on;

void inkrementiraj()
{
    float broj = timer1.read();
    
    cifra3 = int((broj - int(broj))*10);
    cifra2 = int(broj) % 10;
    cifra1 = int(broj) / 10;
}

void osvjezi()
{
   if(izborCifre == 3)
   {
        enable = izborCifre;
        display = cifre[cifra3];
        izborCifre = 5;
   }
   else if(izborCifre == 5)
   {
        enable = izborCifre;
        point = 0;
        display = cifre[cifra2];
        izborCifre = 6;
   }
   else
   {
        point = 1;
        enable = izborCifre;
        display = cifre[cifra1];
        izborCifre = 3;
   }
}

void startstop()
{
    if(debounce.read_ms() > 400)
    {
        if(on) timer1.stop();
        else timer1.start();
        on = !on;     
        debounce.reset();
    }
}

void resetfunc()
{
    if(debounce1.read_ms() > 400)
    {
        timer1.reset();
        timer1.stop();
        debounce1.reset();
    }
}

int main() {
    enable = 0;
    display = 0x40;
    debounce.start();
    debounce1.start();
    ticker1.attach(&osvjezi, 0.005);
    ticker2.attach(&inkrementiraj, 0.1);
    timer1.start();
    on = true;
    t1.rise(&startstop);
    t2.rise(&resetfunc);
    while(1) {
    }
}
