#include "mbed.h"
DigitalOut ENBL = dp14;
BusOut bDISP (dp23, dp24, dp25);
BusOut dDISP[3] = {dp23, dp24, dp25};
 
BusOut bDIGIT(dp2, dp1, dp28, dp6, dp5, dp27, dp26); // (dp26, dp27, dp5, dp6, dp28, dp1, dp2);
DigitalOut dDIGIT[7] = {dp2, dp1, dp28, dp6, dp5, dp27, dp26};
DigitalOut DECP (dp4);
DigitalOut eA(dp26), eB(dp27), eC(dp5), eD(dp6), eE(dp28), eF(dp1), eG(dp2);
 
typedef unsigned long T;
template <T N>
class eBIN
    {
    public: 
        enum {VAL = (N % 8) + (eBIN<N/8>::VAL << 1)};
    };
template <>
class eBIN<0>
    {
    public:
        enum {VAL = 0};
    };
#define BIN(N) eBIN<0##N>::VAL
 
enum Keys {N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, A, B, C, D, Star, Hash, None = -1};
enum Diodes {D1 = 6, D2 = 5, D3 = 3};
void Display (Keys Key, Diodes Diode, bool DisplayPoint)
    {
        if (Key == None) return;
        
        DECP = DisplayPoint ? 0 : 1;
        switch (Key)
            {
                case N0:
                    bDIGIT = BIN(0000001); //1
                    break;
                case N1:
                    bDIGIT = BIN(1001111); //79
                    break;
                case N2:
                    bDIGIT = BIN(0010010); //18
                    break;
                case N3:
                    bDIGIT = BIN(0000110); //6
                    break;
                case N4:
                    bDIGIT = BIN(1001100); //76
                    break;
                case N5:
                    bDIGIT = BIN(0100100); //36
                    break;
                case N6:
                    bDIGIT = BIN(0100000); //32
                    break;
                case N7:
                    bDIGIT = BIN(0001111); //15
                    break;
                case N8:
                    bDIGIT = BIN(0000000); //0
                    break;
                case N9:
                    bDIGIT = BIN(0000100); //4
                    break;
                case A:
                    bDIGIT = BIN(0001000); //A //8
                    break;
                case B:
                    bDIGIT = BIN(1100000); //b //96
                    break;
                case C:
                    bDIGIT = BIN(1110010); //c //114
                    break;
                case D:
                    bDIGIT = BIN(0000010); //d //2
                    break;
                case Star:
                    //xD ovo je 'e' slovo. Za gornje 'o' slovo je 0011100, za 'u' je 1100011 a za donje 'o' je 1100010
                    bDIGIT = BIN(0010000); // 16 //za 'P' = 0011000
                    break;
                case Hash:
                    bDIGIT = BIN(1001000); //slovo H kao HASH :D //72
                    break;
                case None:
                    bDIGIT = BIN(1111111); //127
                    break;
            }
            bDISP = (int)Diode;
        
    } 
void DisplayKeys (Keys K1, Keys K2, Keys K3, unsigned int Point, int DelayMS = 10)
    {
        Display (K1, D1, Point == 1);
        if (K1 != None) wait_ms (DelayMS);
        Display (K2, D2, Point == 2);
        if (K2 != None) wait_ms (DelayMS);
        Display (K3, D3, Point == 3);
        if (K3 != None) wait_ms (DelayMS);
    }
double Zaokruzi (double broj) //Na 2 dec
    {
        return double(int(broj * 100.0 + .5) / 100.0);
    }
double Zaokruzi2 (double broj) //Na 3 dec
    {
        return double(int(broj * 1000.0 + .5) / 1000.0);
    }
void DajCifre (double N, int &Cio, int &PrvaDec, int &DrugaDec) //broj u #.## formatu
    {
        double dec = (N - (int)N);
        dec = Zaokruzi(dec * 100.);
        DrugaDec = (int)dec % 10;
        PrvaDec = ((int)dec / 10) % 10;
        Cio = (int)N;
    }

void DajCifre (double N, int &Cio, int &PrvaDec, int &DrugaDec, int &TrecaDec) //broj u #.### formatu
    {
        double dec = (N - (int)N);
        dec = Zaokruzi2(dec * 1000.);
        TrecaDec = (int)dec % 10;
        DrugaDec = ((int)dec / 10) % 10;
        PrvaDec = ((int)dec / 100) % 10;
        Cio = (int)N;
    }
AnalogIn aIN (dp9);
//LV4-Grupa1-Tim003-Zadatak2
int main() { //Zadatak 1.
    ENBL = 1; //Provjeri
    int C = 0, PD = 0, DD = 0, TD = 0, b = 0;
    double Napon = 0.;
    while(1) 
        {
            if (b == 500) {Napon = aIN * 3.3 * 10.0 ; b = 0;}
            b++;
            DajCifre (Napon, C, PD, DD);
            DisplayKeys ((Keys)C, (Keys)PD, (Keys)DD, 2, 1);
            //wait (0.2);
        }
    }
int main_2()
    {
        
    }