#include "mbed.h"
#include "N5110.h"

//Deklaracija LCD objekta
//N5110 lcd(VCC, SCE, RST, D/C, MOSI, SCLK, LED)
N5110 lcd(PTC12, PTC13, PTC16, PTC17, PTD6, PTD5, PTD4);
//Digitalni izlaz za deaktivaciju LED buffera
//DigitalOut enable ();

void crtajDesno(int x, int y, int brojPiksela) {

 lcd.setPixel(x,y);
 for(int i=1; i<brojPiksela; i++) {
   lcd.setPixel(x+i,y);
 }
 lcd.refresh();
}

void crtajLijevo(int x, int y, int brojPiksela)
{
    for(int i=1; i<=brojPiksela; i++ ) {
        lcd.setPixel(x-i,y);
    }
    lcd.refresh();
}

void crtajGore(int x, int y, int brojPiksela)
{

    for(int i=1; i<=brojPiksela; i++) {
        lcd.setPixel(x,y+i);
    }
    lcd.refresh();
}

void obrisi(int x, int y, int brojPiksela)
{

    for(int i=1; i<=brojPiksela; i++) {
        lcd.clearPixel(x,y+i);
    }
    lcd.refresh();
}

void crtajDolje(int x, int y, int brojPiksela)
{
    lcd.setXYAddress(0,0);
    for(int i=1; i<=brojPiksela; i++) {
        lcd.setPixel(x,y+i);
    }
    lcd.refresh();
}

void crtajLopticu(int x, int y)
{
    lcd.setPixel(x,y);
    lcd.setPixel(x+1,y);
    lcd.setPixel(x+2,y);

    lcd.setPixel(x-1,y-1);
    lcd.setPixel(x,y-1);
    lcd.setPixel(x+1,y-1);
    lcd.setPixel(x+2,y-1);
    lcd.setPixel(x+3,y-1);

    lcd.setPixel(x-1,y-2);
    lcd.setPixel(x,y-2);
    lcd.setPixel(x+1,y-2);
    lcd.setPixel(x+2,y-2);
    lcd.setPixel(x+3,y-2);

    lcd.setPixel(x-1,y-3);
    lcd.setPixel(x,y-3);
    lcd.setPixel(x+1,y-3);
    lcd.setPixel(x+2,y-3);
    lcd.setPixel(x+3,y-3);

    lcd.setPixel(x,y-4);
    lcd.setPixel(x+1,y-4);
    lcd.setPixel(x+2,y-4);

    lcd.refresh();
}

void obrisiLopticu(int x, int y)
{
    lcd.clearPixel(x,y);
    lcd.clearPixel(x+1,y);
    lcd.clearPixel(x+2,y);

    lcd.clearPixel(x-1,y-1);
    lcd.clearPixel(x,y-1);
    lcd.clearPixel(x+1,y-1);
    lcd.clearPixel(x+2,y-1);
    lcd.clearPixel(x+3,y-1);

    lcd.clearPixel(x-1,y-2);
    lcd.clearPixel(x,y-2);
    lcd.clearPixel(x+1,y-2);
    lcd.clearPixel(x+2,y-2);
    lcd.clearPixel(x+3,y-2);

    lcd.clearPixel(x-1,y-3);
    lcd.clearPixel(x,y-3);
    lcd.clearPixel(x+1,y-3);
    lcd.clearPixel(x+2,y-3);
    lcd.clearPixel(x+3,y-3);

    lcd.clearPixel(x,y-4);
    lcd.clearPixel(x+1,y-4);
    lcd.clearPixel(x+2,y-4);

}




int main()
{


    lcd.init();
    
       crtajDesno(0,0,57);
       crtajDolje(22,0,5);
       crtajDolje(56,0,5);
       crtajDesno(62,0,21);
      crtajDolje(0,0,47);
      crtajDolje(82,0,26);
      crtajDolje(82,31,15);
      crtajDesno(0,47,83);
       
       crtajLijevo(83,31,7);
       crtajDesno(0,20,5);
       //crtajGore(6,20,14);
       crtajDolje(5,20,15); 
       crtajDesno(6,40,40);
       crtajDesno(51,40,26);
       //crtajGore(41,40,6);
     
       //crtajGore(76,40,8); //vidi hoce li se spojiti
      // crtajGore(76,32,20);
       //crtajLijevo(76,6,33);
       //crtajLijevo(38,6,33);
      // crtajDolje(37,6,5);
       //crtajDolje(5,6,14);
       //2. nivo
       crtajDesno(6,6,33);
       crtajDesno(44,6,33);
       crtajDolje(76,6,20); 
       crtajDolje(76,31,8);
       crtajGore(41,35,4);
       crtajDolje(5,6,14);
       crtajDolje(38,6,4);
       
       //3. nivo
       crtajDesno(11,11,22);
       crtajDesno(38,11,34); 
       crtajDolje(11,11,10);
       crtajDolje(11,26,9); 
       crtajDesno(11,35,61);
       crtajGore(71,10,25);
       crtajDolje(32,11,6); 
       crtajDolje(65,11,6); 
       crtajLijevo(71,23,10); 
       crtajDesno(11,29,6);
       crtajGore(17,17,12); 
       crtajDesno(23,17,43);
       crtajDolje(23,17,9); 
       crtajDesno(23,26,17);
       
       
       
       
       
  //  lcd.refresh();
 crtajLopticu(20,20);

    while(1) {
    }
}