#include "mbed.h"
#include "nRF24L01P.h"
#include <string>
#define TRANSFER_SIZE 4

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
int txDataCnt = 0;
int rxDataCnt = 0;

string zaPoslat;
int brZaPoslat(0);

void primiPoruku() {
    
}


void saljiPoruku() {
    for(int i = 0; i<zaPoslat.size(); i+=4) if(i<zaPoslat.size()-4)
    my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char*)zaPoslat.substr(i,4).c_str(),  zaPoslat.substr(i,4).size());
    zaPoslat.clear();
}

int main() {
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable(); 
    while (1) {
        if ( pc.readable() ) {
 
            char znak = pc.getc();
            if(znak == 'x') saljiPoruku();
            else zaPoslat += znak;        
            myled1 = !myled1;
        }
 
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {
 
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
 
            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
 
                pc.putc( rxData[i] );
            }
 
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        }
    }
      
}
