/**
 *  @filename   :   epdif.h
 *  @brief      :   Header file of epdif.cpp providing EPD interface functions
 *                  Users have to implement all the functions in epdif.cpp
 *  @author     :   Yehui from Waveshare
 *
 *  Copyright (C) Waveshare     August 10 2017
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef EPDIF_H
#define EPDIF_H

#define LOW 0;
#define HIGH 1;

#include "mbed.h"

/*
// Pin definition
#define RST_PIN         DigitalOut reset_pin (A2)//rst
#define DC_PIN          DigitalOut dc_pin (A5) //SCL pin on mbed shield
#define CS_PIN          DigitalOut cs_pin (D9)
#define BUSY_PIN        DigitalOut busy_pin (D3)//int
*/
//DigitalOut mosi_pin(D11);
//DigitalOut miso_pin(D12);
//DigitalOut sclk_pin(A5);
//DigitalOut ssel_pin(D9);

class EpdIf
{
public:
    EpdIf(void);
    ~EpdIf(void);

    int  IfInit(void);
    void DigitalWrite(DigitalOut &pin, int value);
    int  DigitalRead(PinName &pin);
    void DelayMs(unsigned int delaytime);
    void SpiTransfer(unsigned char data);
private:
    char rx_buffer[256];
    char tx_buffer[256];
    SPI _spi;
    DigitalOut _cs;
    DigitalOut reset_pin;
    DigitalOut dc_pin;
    DigitalOut busy_pin;
    
    
};

#endif
