#include "mbed.h"
#include "Shed.h"
#include "Datetime.h"
using namespace std;

Shed::Shed(string json) {
    /* Voorbeeld json input
    "
        "id":"7",
        "lokaal":"2.85",
        "start":"2019-03-22 15:45:00",
        "einde":"2019-03-28 18:45:00",
        "prof":"J. Lannoo",
        "klasgroep":"1e Bachelor ME",
        "vak":"Sterkteleer",
        "comments":"Extra lokaal 4.20 via video"
    "
    */
    string start_str = "";
    string einde_str = "";
    int param = 0;
    bool startCmd = false;
    bool endCmd = false;
    bool startParam = false;
    bool endParam = false;
    for(int i = 0; i < json.length(); i++) {
        char c = json.at(i);
        if(c == '"') {
            //Eerste keer is er nog geen startCmd, vanaf dan is deze altijd true
            //als dan de endParam true is, is het de volgende cmd eigenlijk dus alles herinitialiseren
            if(!startCmd || endParam) {
                endCmd = false;
                startParam = false;
                endParam = false;
                startCmd = true;
                param++;
            } else if(!endCmd) {
                endCmd = true;
            } else if(!startParam) {
                startParam = true;
            } else if(!endParam) {
                endParam = true;
            }
        } else {        
            if(startParam && !endParam) {
                //Waarde aan het lezen
                switch(param) {
                    case 1: {
                        //id
                        //Not needed
                    } break;
                    case 2: {
                        //lokaal
                        this->lokaal += c;
                    } break;
                    case 3: {
                        //start
                        start_str += c;
                    } break;
                    case 4: {
                        //einde
                        einde_str += c;
                    } break;
                    case 5: {
                        //prof
                        this->prof += c;
                    } break;
                    case 6: {
                        //klasgroep
                        this->klasgroep += c;
                    } break;
                    case 7: {
                        //vak
                        this->vak += c;
                    } break;
                    case 8: {
                        //comments
                        this->comments += c;
                    } break;
                    default: {
                        //Error
                    }
                }
            }/* else if(startCmd && !endCmd) {
                //Commando aan het lezen
                //Not needed
            }*/
        }
    }
    //Save start & einde as Datetime
    this->start = new Datetime(start_str);
    this->einde = new Datetime(einde_str);
}

Shed::~Shed() {
    //strings are freed automatically
    //Needed for datetime (found on: https://stackoverflow.com/a/677661)
    //but this freezes the mbed without errors, so don't?
    //delete this->start;
    //delete this->einde; 
}

string Shed::getLokaal() {
    return lokaal;
}

Datetime* Shed::getStart() {
    return start;
}

Datetime* Shed::getEinde() {
    return einde;
}

string Shed::getProf() {
    return prof;
}

string Shed::getKlasgroep() {
    return klasgroep;
}

string Shed::getVak() {
    return vak;
}

string Shed::getComments() {
    return comments;
}

//Er mag hier geen static voor staan als je een pointer wil gebruiken als return. Er staat wel een static voor in de header hiermee weet de main genoeg
vector<Shed>* Shed::getShedVector(vector<string> jsons) {
    vector<Shed> sheds;
    for(int i = 0; i < jsons.size(); i++) {
        sheds.push_back(Shed(jsons[i]));
    }
    return &sheds;
}
