/**
 *  @filename   :   epdif.cpp
 *  @brief      :   Implements EPD interface functions
 *                  Users have to implement all the functions in epdif.cpp
 *  @author     :   Yehui from Waveshare
 *
 *  Copyright (C) Waveshare     August 10 2017
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "epdif.h"
#include "SPI.h"

//DigitalOut cs_pin (D9);


EpdIf::EpdIf():_spi(D11,D12,D13),/*_cs(D9)*/dc_pin(D5),busy_pin(D3),reset_pin(A2),_cs(D9){
    int whoami = 20;
    _spi.format(8,3);
    _spi.frequency(2000000);
    _cs = 0;
    _spi.write(0x8F);
    whoami = _spi.write(0x00);
    printf( "pre print \r\n");
    printf("WHOAMI register = 0x%X\r\n", whoami);
    printf( "post print \r\n");
    _cs = 1;
};

//EpdIf::EpdIf() {};

EpdIf::~EpdIf(void) {
};

void EpdIf::DigitalWrite(DigitalOut &pin, int value) {
    //digitalWrite(pin, value);
    pin = value;
    //pin_val value;   
}

int EpdIf::DigitalRead(PinName &pin) {
    //return DigitalOut(pin).read();
    //DigitalOut pin_val(pin);
    return pin;
}

void EpdIf::DelayMs(unsigned int delaytime) {
    //delay(delaytime);
    
    wait ((((float)delaytime)/100));
}

void EpdIf::SpiTransfer(unsigned char data) {
    //DigitalOut(CS_PIN, LOW);
    //DigitalOut cs_pin(D9);
    _cs = 0;
    //SPI.transfer(data);
    //_spi.transfer (*tx_buffer , 256,*rx_buffer,256,NULL,SPI_EVENT_COMPLETE);
    //for (int i=0; i< 256; i++)
    //{
    
    int result = _spi.write(data);
    //printf("SPI_transfer_reply %i\r\n",result);
    
    //}
    
    //DigitalOut(CS_PIN, HIGH);
    _cs = 1;
}

int EpdIf::IfInit(void) {
    //pinMode(CS_PIN, OUTPUT);
    //pinMode(RST_PIN, OUTPUT);
    //pinMode(DC_PIN, OUTPUT);
    //pinMode(BUSY_PIN, INPUT); 
    //_spi.beginTransaction(SPISettings(2000000, MSBFIRST, SPI_MODE0));
    //_spi.begin();
    return 0;
}

