#ifndef SHED_H
#define SHED_H
#include <string>
#include <sstream>
#include <iostream>
#include <vector>
#include "Datetime.h"

using namespace std;
/**
* This class Shed can be used to act as one sheduled class (of many)
*
* @author  Jordy Ampe
* @version 1.0
* @since   2019-05-08
*/
class Shed{
    private:
        string lokaal;
        Datetime* start;
        Datetime* einde;
        string prof;
        string klasgroep;
        string vak;
        string comments;
    public:        
        /**
        * Constructor to make a Shed from json as a string
        * @param json is a string with the received json for one shedules class from the API
        */
        Shed(string json);
        
        /**
        * Destructor for a Shed
        */
        ~Shed();
        
        /**
        * @return lokaal as a string
        */
        string getLokaal();
        
        /**
        * @return start as a Datetime*
        */
        Datetime* getStart();
        
        /**
        * @return einde as a Datetime*
        */
        Datetime* getEinde();
        
        /**
        * @return prof as a string
        */
        string getProf();
        
        /**
        * @return Klasgroep as a string
        */
        string getKlasgroep();
        
        /**
        * @return vak as a string
        */
        string getVak();
        
        /**
        * @return comments as a string
        */
        string getComments();
        
        /**
        * @param jsons is a vector of json formated shedules
        * @return * to the vector of Shed's
        */
        static vector<Shed>* getShedVector(vector<string> jsons);
};
#endif
