#ifndef ESP8266_H
#define ESP8266_H

#include <vector>
#include <string>
#include "mbed.h"

class Esp8266 {
    public:
        explicit Esp8266(PinName TX, PinName RX, int BaudRate, PinName ResetPin, PinName ChipSelect);
        void connectToAP(const char* SSID, const char* Password);
        std::string getRequest(const char* TCPorUDP, const char* Server, int Port, const char* ConnectionString, bool stayAlive);
        void setModuleMode(int Mode);
        std::vector<std::string> processJsonString(std::string response);
    private:
        DigitalOut *rst;
        DigitalOut *cs;
        int baud;
        PinName tx;
        PinName rx;
        ATCmdParser *parser;
        UARTSerial *serial;
        void setupModule(PinName TX, PinName RX, int BaudRate);
        void toggleResetPin(void);
        void closeConnection(void);
        std::string getJsonString(void);
};

#endif
