#include "Esp8266.h"
#include <vector>
using namespace std;

Esp8266::Esp8266(PinName TX, PinName RX, int BaudRate, PinName ResetPin, PinName ChipSelect) {
   rst = new DigitalOut(ResetPin);
   cs = new DigitalOut(ChipSelect);
   setupModule(TX, RX, BaudRate);
}

void Esp8266::setupModule(PinName TX, PinName RX, int BaudRate) {
    cs->write(1);
    serial = new UARTSerial(TX, RX, BaudRate);
    parser = new ATCmdParser(serial);
    parser->debug_on(0);
    parser->set_delimiter("\r\n");
    cs->write(0);
}

void Esp8266::toggleResetPin(void) {
    rst->write(0);
    wait(0.01);
    rst->write(1);
}

void Esp8266::setModuleMode(int Mode) {
    cs->write(1);
    toggleResetPin();
    bool processed = false;
    do {
        processed = parser->send("AT+CWMODE=%d", Mode) && parser->recv("OK");
    }
    while(processed == false);
}

void Esp8266::connectToAP(const char* SSID, const char* Password) {
    bool processed = false;
    do {
        processed = parser->send("AT+CWJAP_CUR=\"%s\",\"%s\"", SSID, Password) && parser->recv("OK");
    }
    while(processed == false);
}

string Esp8266::getRequest(const char* TCPorUDP, const char* Server, int Port, const char* ConnectionString, bool stayAlive) {
    bool processed = false;
    do {
        processed = parser->send("AT+CIPSTART=\"%s\",\"%s\",%d", TCPorUDP, Server, Port) && parser->recv("OK");
    }
    while(processed == false);

    string con = "GET ";
    con.append(ConnectionString);
    con.append(" HTTP/1.1\r\nHost: ");
    con.append(Server);
    con.append("\r\n\r\n");

    do {
        processed = parser->send("AT+CIPSEND=%d", con.length()) && parser->recv("OK");
    }
    while(processed == false);

    parser->send("%s", con.c_str());
    if(!stayAlive) {
        closeConnection();
    }
    return getJsonString();
}

void Esp8266::closeConnection(void) {
    bool processed = false;
    do {
        processed = parser->send("AT+CIPCLOSE");
    }
    while(processed == false);
}

string Esp8266::getJsonString(void) {
    char previousChar = ' ';
    char presentChar = ' ';
    bool startOfJSON = false;

    string resp = "";

    while(1) {
        presentChar = (char)parser->getc();
        
        if(presentChar == '{' && previousChar == '[') {
            startOfJSON = true;
        }

        if(startOfJSON) {
            resp += presentChar;
        }

        if(presentChar == ']' && previousChar == '}') {
            break;
        }

        previousChar = presentChar;
    }

    cs->write(0);
    return resp;
}

vector<string> Esp8266::processJsonString(string response) {
    vector<string> jsonStrings;
    response = response.substr(0, response.length()-1);

    int delimiterPlace = 0;
    do {
        delimiterPlace = response.find("},{")-2;
        string sub;
        if(delimiterPlace < 0) {
            if(response[0] != '{')
                sub = response.substr(2, response.length()-3);
            else
                sub = response.substr(1, response.length()-2);

            jsonStrings.push_back(sub);
            break;
        }
        else {
            sub = response.substr(1, delimiterPlace+1);
            jsonStrings.push_back(sub);
            response.erase(0, delimiterPlace+4);
        }
    }
    while(delimiterPlace > 0);

    return jsonStrings;
}
