#ifndef DATETIME_H
#define DATETIME_H
#include <string>
#include <sstream>
#include <iostream>
using namespace std;

/**
* This class Shed can be used to act as one sheduled class (of many)
*
* @author  Jordy Ampe
* @version 1.0
* @since   2019-05-08
*/
class Datetime{
    private:
        int day;
        int month;
        int year;
        int hour;
        int minute;
        int second;
    public:        
        /**
        * Constructor to make a Shed from json as a string
        * @param json is a string with the received json for one shedules class from the API
        */
        Datetime(string datetime);
        
        /**
        * Destructor for a Datetime
        */
        ~Datetime();
        
        /**
        * @return day as an int
        */
        int getDay();
        
        /**
        * @return month as an int
        */
        int getMonth();
        
        /**
        * @return year as an int
        */
        int getYear();
        
        /**
        * @return hour as an int
        */
        int getHour();
        
        /**
        * @return minute as an int
        */
        int getMinute();
        
        /**
        * @return second as an int
        */
        int getSecond();
        
        /**
        * @return datetime as a string in belgium format dd/mm/yyyy hh:mm:ss
        */
        string getDatetime();
        
        /**
        * @return date as a string in belgium format dd/mm/yyyy
        */
        string getDate();
        
        /**
        * @return time as a string in belgium format hh:mm:ss
        */
        string getTime();
            
};
#endif
