#include "mbed.h"
#include "Datetime.h"
#include <string>
#include <sstream>
#include <iostream>
using namespace std;

Datetime::Datetime(string datetime) {
    /* Voorbeeld datetime input
    "2019-03-22 15:45:00"
    */
    this->year = atoi(datetime.substr(0,4).c_str());
    this->month = atoi(datetime.substr(5,2).c_str());
    this->day = atoi(datetime.substr(8,2).c_str());
    this->hour = atoi(datetime.substr(11,2).c_str());
    this->minute = atoi(datetime.substr(14,2).c_str());
    this->second = atoi(datetime.substr(17,2).c_str());
}

Datetime::~Datetime() {
    //int's are freed automatically
}

int Datetime::getDay() {
    return day;
}

int Datetime::getMonth() {
    return month;
}

int Datetime::getYear() {
    return year;
}

int Datetime::getHour() {
    return hour;
}

int Datetime::getMinute() {
    return minute;
}

int Datetime::getSecond() {
    return second;
}

string Datetime::getDate() {
    string date = "";
    string buf; // string which will contain the result
    ostringstream convert0; // stream used for the conversion
    ostringstream convert1;
    ostringstream convert2;
    convert0 << day; // insert the textual representation of 'Number' in the characters in the stream
    buf = convert0.str(); // set 'Result' to the contents of the stream    
    if(day < 10) {date += "0";}
    date += buf + "/";
    if(month < 10) {date += "0";}
    convert1 << month;
    buf = convert1.str();
    date += buf + "/";
    convert2 << year;
    buf = convert2.str();
    date += buf;
    return date;
}

string Datetime::getTime() {
    string time = "";
    string buf; // string which will contain the result
    ostringstream convert0; // stream used for the conversion
    ostringstream convert1;
    ostringstream convert2;
    convert0 << hour; // insert the textual representation of 'Number' in the characters in the stream
    buf = convert0.str(); // set 'Result' to the contents of the stream
    if(hour < 10) {time += "0";}
    time += buf + ":";
    if(minute < 10) {time += "0";}
    convert1 << minute;
    buf = convert1.str();
    time += buf + ":";
    if(second < 10) {time += "0";}
    convert2 << second;
    buf = convert2.str();
    time += buf;
    return time;
}

string Datetime::getDatetime() {
    return getDate() + " " + getTime();
}
