#include "mbed.h"
#include "TempBase.h"


TempBase::TempBase()
{
    ambientTemp = 25.0f;
    v25         = 760.0f;
    avgSlope    = 2.5f;
    vRef        = 3000.0f;
}


TempBase::TempBase(float correction)
{
    ambientTemp = 25.0f + correction;
    v25         = 760.0f;
    avgSlope    = 2.5f;
    vRef        = 3000.0f;
}

// ADC init function, call it 1 time during setup
void TempBase::Init()
{
    hadc1.Instance = ADC1;
    hadc1.Init.ClockPrescaler = ADC_CLOCKPRESCALER_PCLK_DIV4;
    hadc1.Init.Resolution = ADC_RESOLUTION12b;
    hadc1.Init.ScanConvMode = DISABLE;
    hadc1.Init.ContinuousConvMode = DISABLE;
    hadc1.Init.DiscontinuousConvMode = DISABLE;
    hadc1.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;
    hadc1.Init.DataAlign = ADC_DATAALIGN_RIGHT;
    hadc1.Init.NbrOfConversion = 1;
    hadc1.Init.DMAContinuousRequests = DISABLE;
    hadc1.Init.EOCSelection = EOC_SINGLE_CONV;
    HAL_ADC_Init(&hadc1);   
        
    sConfig.Channel = ADC_CHANNEL_TEMPSENSOR; 
    sConfig.Rank = 1;
    sConfig.SamplingTime = ADC_SAMPLETIME_3CYCLES;  
        
    HAL_ADC_ConfigChannel(&hadc1, &sConfig);
}
    
// returns raw adc value from sensor    
int TempBase::GetRawTemp()
{
    HAL_ADC_Start(&hadc1); // Start conversion
            
    // Wait end of conversion and get value
    if (HAL_ADC_PollForConversion(&hadc1, 10) == HAL_OK) 
        return HAL_ADC_GetValue(&hadc1);
    else return -1;
}
    
// takes raw value and convert it to temp    
float TempBase::ConvertTemp(int value)
{
    return (((value * vRef / 0xFFF) - v25) / avgSlope) + ambientTemp;   // formula is from manual
}