#include "mbed.h"
#include "adxl345.h"
#include <string>

#define DEBUG       // it doesnt use modem in debug mode. I dont have it and code will stack on my prototype cuz will never receive answers from modem.
                    // comment this line to turn off debug mode

// skywire -------------------
/* --CHANGE THIS FOR YOUR SETUP-- */
#define DeviceID "yourDeviceIDhere"  //Freeboard DweetIO unique ID
/* --CHANGE THIS FOR YORU SETUP (IF APPLICABLE)-- */
string APN = "yourAPNhere";
// ===========================

PwmOut mypwm(D3);
Ticker timer1;

ADXL345 adxl;

int x, y, z;

volatile char input_buffer[90];             // store everything received 
volatile char message_buffer[90];           // store message
volatile char input_buffer_counter = 0;   
volatile char message_counter = 0;  
volatile char input_flag = false;

volatile char latitude[15] = {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '};
volatile char longtitude[15] = {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '};
volatile char coorFlag = 0;

volatile int period = 1000;         // buzzer variables
volatile int rising = 1;


// skywire ------------------------
DigitalOut skywire_en(PA_6);                        // Skywire Enable
DigitalOut skywire_rts(PA_7);                       // Skywire Send
Serial skywire(PA_9,PA_10);                         // Serial comms to Skywire
// Variables for UART comms
volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 600;
char rx_buffer[buffer_size+1];
char rx_line[buffer_size];
// char array for reading from Skywire
char str[255];
// ===============================

Serial pcSerial(SERIAL_TX, SERIAL_RX, 9600);  // tx, rx     // pc 
Serial gpsSerial(A0, A1, 9600);  // tx, rx                  // gps

I2C i2cAcc(I2C_SDA, I2C_SCL);

DigitalOut led(LED1);

void ADXL_ISR();
void rxHandler();
void data_send();
void alarm_on();
void alarm_off();



//===================================================================
//FUNCTIONS
//===================================================================
/********************* ISR *********************/
/* Look for Interrupts and Triggered Action    */
void ADXL_ISR() {
  
  // getInterruptSource clears all triggered actions after returning value
  // Do not call again until you need to recheck for triggered actions
  int interrupts = adxl.getInterruptSource();
  
  // Free Fall Detection
  if(adxl.triggered(interrupts, ADXL345_FREE_FALL)){
    pcSerial.printf("*** FREE FALL ***\n");
    
    alarm_on();     // turn of alarm
    led = 1;        // turn led on
    
    #ifndef DEBUG
    data_send();        // send data if not in debug mode
    #else
    wait(10);      // just wait if in debug
    #endif
    
    alarm_off();    // turn alarm off
    led = 0;        // turn led off
  } 
}

//===================================================================
// RX interrupt handler
// stores everything into input_buffer
void rxHandler()
{
  char tmp;
  
  do
  {
    tmp = gpsSerial.getc();       // read serial data
  
    if(tmp == '$')                    // if message start character( every nmea message starts with $)
    {
      input_buffer_counter = 0;       // reset inut buffer counter
      return;
    }
  
    if(tmp == '*')                    // if end of message( every nmea message ends with *+CRC)
    { 
      input_buffer[input_buffer_counter] = tmp;
      input_buffer_counter++; 
      if(input_buffer[3] == 'L')      // if nmea string type is GPGLL
      {
          int t = 0; 
          int lat = 0;
          int lon = 0;
          
          for(int i=0; i<15; i++)           // clear latitude and longtitude
          {
              latitude[lat++] = ' '; 
              longtitude[lon++] = ' ';
          }
          
          while(input_buffer[t] != ',')      // find coma after GPGLL
            t++;                            // t points coma after GPGLL
            
          t++;              // set to to first latitude character
          
          
          lat = 0;
          
          while(input_buffer[t] != ',')      // copy latitude value
          {
            latitude[lat] = input_buffer[t];
            lat++;
            t++;                            // t points coma after latitude 
          }    
          latitude[lat] = input_buffer[t];          // copy coma
          lat++;
          t++; 
          latitude[lat] = input_buffer[t];          // copy N or S direction
          lat++;
          t++; 
          latitude[lat] = '\0';         // write null character

          t++;              // set t to first character of longtitude
          
          
          lon = 0;
          
          while(input_buffer[t] != ',')      // copy longtitude value
          {
            longtitude[lon] = input_buffer[t];
            lon++;
            t++;                            // t points coma after longtitude 
          }    
          longtitude[lon] = input_buffer[t];          // copy coma
          lon++;
          t++; 
          longtitude[lon] = input_buffer[t];          // copy W or E direction
          lon++;
          longtitude[lon] = '\0';         // write null character
          
          coorFlag = 1;      
      }
      return;
    }
    input_buffer[input_buffer_counter] = tmp;
    input_buffer_counter++;
  }
  while(gpsSerial.readable());
}

//===================================================================
// Read line from the UART
void read_line() 
{
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    __disable_irq();
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\n')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            __enable_irq();
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            __disable_irq();
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    __enable_irq();
    rx_line[i-1] = 0;
    return;
}

//=======================================================================
// Wait for specific response
int WaitForResponse(char* response, int num) 
{
    do {
        read_line();
        pcSerial.printf("Waiting for: %s, Recieved: %s\r\n", response, rx_line);
    } while (strncmp(rx_line, response, num));
    return 0;
}

//==========================================================================
// Interrupt for the Skywire
void Skywire_Rx_interrupt()
{
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((skywire.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = skywire.getc();
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}

void data_send()
{
    skywire.printf("AT+SQNSD=3,0,80,\"dweet.io\"\r\n");
    WaitForResponse("CONNECT", 7);
    
    pcSerial.printf("Sending information...\r\n");
    // Report the sensor data to dweet.io
    skywire.printf("POST /dweet/for/%s?latitude=%s&longtitude=%s HTTP/1.0\r\n\r\n", DeviceID, latitude, longtitude);

    // Wait for response from dweet.io
    WaitForResponse("OK", 2);
    wait(1);
}

void modem_init()
{
    //Enable Skywire
    skywire_en=0;
    wait(2);
    skywire_en=1;
    wait(2);
    skywire_en=0;

    // Wait for modem to initialize
    wait(60);
    
    //Turn off echo
    // Helps with checking responses from Skywire
    pcSerial.printf("Turning off echo...\r\n");
    skywire.printf("ATE0\r\n");
    WaitForResponse("OK", 2);

    // Turn on DNS Response Caching
    // Used on the Telit-based Skywires
    pcSerial.printf("Turning on DNS Cacheing to improve speed...");
    skywire.printf("AT#CACHEDNS=1\r\n");
    WaitForResponse("OK", 2);
    
    pcSerial.printf("Connecting to Network...\r\n");
    // get IP address
    // The last parameter in AT+SQNSCFG sets the timeout if transmit buffer is not full
    // Time is in hundreds of ms: so, a value of 5 = 500ms
    pcSerial.printf("Configuring context part 1...\r\n");
    skywire.printf("AT+SQNSCFG=3,3,300,90,600,5\r\n");
    WaitForResponse("OK", 2);
    wait(1);
    pcSerial.printf("Configuring context part 2...\r\n");
    skywire.printf("AT+CGDCONT=3,\"IP\",\"vzwinternet\"\r\n");
    WaitForResponse("OK", 2);
    wait(1);
    pcSerial.printf("Activating context...\r\n");
    skywire.printf("AT+CGACT=1,3\r\n");
    WaitForResponse("OK", 2);
}

// interrupt using for encreasing/decreasing tone
void attime()
{
    
    if(rising == 1)
    {
        if(period < 1500)
            period += 19;
        else
            rising = 0;
    }
    else
    {
        if(period > 1000)
            period -= 19;
        else
            rising = 1;
    }
    
    mypwm.period_us(period);
    mypwm.pulsewidth_us(period/2); 
}

// turn alarm sound on
void alarm_on()     
{
    timer1.attach(&attime, 0.01);
}

// turn alarm sound off
void alarm_off()
{
    mypwm.pulsewidth(0);
    timer1.detach();
}



// MAIN -=-=-=-=-=-=-=-=-
//++++++++++++++++++++++++++++++++++++++++++++++++++++
int main() {
    
    skywire.baud(115200);
    skywire.attach(&Skywire_Rx_interrupt, Serial::RxIrq);
    
    i2cAcc.frequency(100000);
    
    adxl.powerOn();                     // Power on the ADXL345

    adxl.setRangeSetting(8);           // Give the range settings
                                      // Accepted values are 2g, 4g, 8g or 16g
                                      // Higher Values = Wider Measurement Range
                                      // Lower Values = Greater Sensitivity
 
    // Set values for what is considered FREE FALL (0-255)
    adxl.setFreeFallThreshold(9);       // (5 - 9) recommended - 62.5mg per increment
    adxl.setFreeFallDuration(15);       // (20 - 70) recommended - 5ms per increment
 
    // Setting all interupts to take place on INT1 pin
    adxl.setImportantInterruptMapping(0, 0, 1, 0, 0);     // Sets "adxl.setEveryInterruptMapping(single tap, double tap, free fall, activity, inactivity);" 
                                                        // Accepts only 1 or 2 values for pins INT1 and INT2. This chooses the pin on the ADXL345 to use for Interrupts.
                                                        // This library may have a problem using INT2 pin. Default to INT1 pin.
  
    // Turn on Interrupts for each mode (1 == ON, 0 == OFF)
    adxl.FreeFallINT(1);

    
    
    pcSerial.printf("SparkFun ADXL345 Accelerometer Hook Up Guide Example\n");
    
    gpsSerial.attach(rxHandler);
    
    #ifndef DEBUG       // if not debug mode
    pcSerial.printf("Starting Demo...\r\n");
    pcSerial.printf("Waiting for Skywire to Boot...\r\n");

    modem_init();       // init modem
    #endif

    
    while(1) {
        
        // Accelerometer Readings
        //int x,y,z;   
        //adxl.readAccel(&x, &y, &z);         // Read the accelerometer values and store them in variables declared above x,y,z
    
        // Output Results to Serial
        /* UNCOMMENT TO VIEW X Y Z ACCELEROMETER VALUES */  
        //mySerial.printf("X: %i\nY: %i\nZ: %i\n================\n", x, y, z);
        //wait(2);
      
        ADXL_ISR();
        // You may also choose to avoid using interrupts and simply run the functions within ADXL_ISR(); 
        //  and place it within the loop instead.  
        // This may come in handy when it doesn't matter when the action occurs. 
        
        
        if(coorFlag)                // show coordinates
        {                      
            pcSerial.printf("message: %s\n", input_buffer);
            pcSerial.printf("latitude: %s\n", latitude);
            pcSerial.printf("longtitude: %s\n", longtitude);
            
            #ifndef DEBUG
            data_send();
            #endif
                
            coorFlag = 0;
        }
        
        
        
    }
}




