#include "Moter.h"

Moter::Moter(PinName pwm, PinName in1, PinName in2):_pwm(pwm), _in1(in1), _in2(in2)
{
    _in1 = 0;
    _in2 = 0;
    _pwm = 0.0;

    _pwm.period(0.001);
}

float Moter::speed(float speed)
{
    if(speed > 0.0) {
        _pwm = speed;
        _in1 = 1;
        _in2 = 0;
    } else if(speed < 0.0) {
        _pwm = -speed;
        _in1 = 0;
        _in2 = 1;
    } else {
        _in1 = 1;
        _in2 = 1;
    }

    return speed == 0 ? 0 : speed > 0 ? 1 : -1;
}