#include "TI_TB6612FNG.h"
#include "mbed.h"

TI_TB6612FNG::TI_TB6612FNG(PinName pwma, PinName ain1, PinName ain2, PinName pwmb, PinName bin1, PinName bin2, PinName standby)
 : _motorL(pwma,ain1,ain2),_motorR(pwmb,bin1,bin2),_standby(standby) {
     _isForward = false;
     _standby = 1;
}

void TI_TB6612FNG::stop()
{
    _motorL = 0;
    _motorR = 0;
    _isForward = false;
}

void TI_TB6612FNG::forward(float speed)
{
    _motorL = speed;
    _motorR = speed;
    _isForward = true;
}

void TI_TB6612FNG::backward(float speed)
{
    _motorL = -1*speed;
    _motorR = -1*speed;
    _isForward = false;
}

void TI_TB6612FNG::left(float speed)
{
    _motorL = -1*speed;
    _motorR = speed;
    _isForward = false;
}

void TI_TB6612FNG::right(float speed)
{
    _motorL = speed;
    _motorR = -1*speed;
    _isForward = false;
}

bool TI_TB6612FNG::isForward() {
    return _isForward;
}