#include "TI_NEOPIXEL_SPI.h"
#include "mbed.h"

TI_NEOPIXEL_SPI::TI_NEOPIXEL_SPI(PinName input) : _ledStrip(input)
{
}

void TI_NEOPIXEL_SPI::switchLightOff(int count)
{

    neopixel::Pixel colors[count];

    for (int i = 0; i < count; i++)
    {
        colors[i].red = 0;
        colors[i].green = 0;
        colors[i].blue = 0;
    }

    _ledStrip.update(colors, count);
}

void TI_NEOPIXEL_SPI::switchLightOn(int count, int startCount, int endCount, rgbColor rgbColor)
{
    neopixel::Pixel colors[count];

    for (int i = 0; i < count; i++)
    {
        if (startCount <= i && i < endCount)
        {
            colors[i].red = rgbColor.red;
            colors[i].green = rgbColor.green;
            colors[i].blue = rgbColor.blue;
        }
        else
        {
            colors[i].red = 0;
            colors[i].green = 0;
            colors[i].blue = 0;
        }
    }

    _ledStrip.update(colors, count);
}

void TI_NEOPIXEL_SPI::changeColor(int count, int startCount, int endCount, rgbColor rgbColor)
{
    neopixel::Pixel colors[count];

    for (int i = 0; i < count; i++)
    {
        if (startCount <= i && i < endCount)
        {
            colors[i].red = rgbColor.red;
            colors[i].green = rgbColor.green;
            colors[i].blue = rgbColor.blue;
        }
        else
        {
            colors[i].red = 0;
            colors[i].green = 0;
            colors[i].blue = 0;
        }
    }

    _ledStrip.update(colors, count);
}

void TI_NEOPIXEL_SPI::changePointColor(int count, int topIndex, int endIndex, rgbColor topColor, rgbColor bottomColor)
{
    neopixel::Pixel colors[count];

    for (int i = 0; i < count; i++)
    {
        if (i == topIndex)
        {
            colors[i].red = topColor.red;
            colors[i].green = topColor.green;
            colors[i].blue = topColor.blue;
        }
        else if (i == endIndex)
        {
            colors[i].red = bottomColor.red;
            colors[i].green = bottomColor.green;
            colors[i].blue = bottomColor.blue;
        }
        else
        {
            colors[i].red = 0;
            colors[i].green = 0;
            colors[i].blue = 0;
        }
    }

    _ledStrip.update(colors, count);
}

void TI_NEOPIXEL_SPI::circle(int count, int startCount, int endCount, rgbColor rgbColor)
{
    for (int j = 0; j < count; j++)
    {
        neopixel::Pixel colors[count];

        for (int i = 0; i < count; i++)
        {
            if (i <= j)
            {
                if (startCount <= i && i < endCount)
                {
                    colors[i].red = rgbColor.red;
                    colors[i].green = rgbColor.green;
                    colors[i].blue = rgbColor.blue;
                }
                else
                {
                    colors[i].red = 0;
                    colors[i].green = 0;
                    colors[i].blue = 0;
                }
            }
            else
            {
                colors[i].red = 0;
                colors[i].green = 0;
                colors[i].blue = 0;
            }
        }

        _ledStrip.update(colors, count);

        if (startCount <= j && j < endCount)
        {
            if (count == 16)
            {
                wait(0.05);
            }
            else
            {
                wait(0.015);
            }
        }
    }
}

void TI_NEOPIXEL_SPI::chase(int count, int bufferCount, rgbColor c1, rgbColor c2)
{
    int virtualCount = count + bufferCount;
    neopixel::Pixel colors[virtualCount];

    for (int j = 0; j < virtualCount; j++)
    {
        colors[j].red = c2.red;
        colors[j].green = c2.green;
        colors[j].blue = c2.blue;
    }

    for (int j = 0; j < count; j++)
    {
        colors[j].red = c1.red;
        colors[j].green = c1.green;
        colors[j].blue = c1.blue;

        colors[j - bufferCount].red = c2.red;
        colors[j - bufferCount].green = c2.green;
        colors[j - bufferCount].blue = c2.blue;

        _ledStrip.update(colors, virtualCount);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.015);
        }
    }
}

void TI_NEOPIXEL_SPI::chase2(int count, int bufferCount, rgbColor c1, rgbColor c2)
{
    for (int j = 0; j < count; j++)
    {
        neopixel::Pixel colors[count];

        for (int i = 0; i < count; i++)
        {
            if (i <= j)
            {
                colors[i].red = c1.red;
                colors[i].green = c1.green;
                colors[i].blue = c1.blue;

                // LEDを節約
                colors[i - bufferCount].red = c2.red;
                colors[i - bufferCount].green = c2.green;
                colors[i - bufferCount].blue = c2.blue;
            }
            else
            {
                colors[i].red = c2.red;
                colors[i].green = c2.green;
                colors[i].blue = c2.blue;
            }
        }

        _ledStrip.update(colors, count);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.015);
        }
    }
}

void TI_NEOPIXEL_SPI::chaseReverse(int count, int bufferCount, rgbColor c1, rgbColor c2)
{
    printf("chaseReverse \n");

    neopixel::Pixel colors[count];

    for (int j = 0; j <= count; j++)
    {
        colors[j].red = c2.red;
        colors[j].green = c2.green;
        colors[j].blue = c2.blue;
    }

    _ledStrip.update(colors, count);

    for (int j = 0; j <= count; j++)
    {
        if (0 <= (count - j))
        {
            colors[count - j].red = c1.red;
            colors[count - j].green = c1.green;
            colors[count - j].blue = c1.blue;
        }

        if (bufferCount <= j)
        {
            colors[count + bufferCount - j].red = c2.red;
            colors[count + bufferCount - j].green = c2.green;
            colors[count + bufferCount - j].blue = c2.blue;
        }

        _ledStrip.update(colors, count);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.015);
        }
    }
}

void TI_NEOPIXEL_SPI::chaseRainbow(int count, int bufferCount)
{
    for (int j = 0; j < count; j++)
    {
        neopixel::Pixel colors[count];

        for (int i = 0; i < count; i++)
        {
            if (i <= j)
            {
                uint8_t phase = 256 / count * i;
                rgbColor rgbColor = convertHsvToRgb(phase / 256.0, 1.0, 1.0);
                colors[i].red = rgbColor.red;
                colors[i].green = rgbColor.green;
                colors[i].blue = rgbColor.blue;

                // LEDを節約
                colors[i - bufferCount].red = 0;
                colors[i - bufferCount].green = 0;
                colors[i - bufferCount].blue = 0;
            }
            else
            {
                colors[i].red = 0;
                colors[i].green = 0;
                colors[i].blue = 0;
            }
        }

        _ledStrip.update(colors, count);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.015);
        }
    }
}

void TI_NEOPIXEL_SPI::circleRainbow(int count)
{
    for (int j = 0; j < count; j++)
    {
        neopixel::Pixel colors[count];

        for (int i = 0; i < count; i++)
        {
            if (i <= j)
            {
                uint8_t phase = 256 / count * i;
                rgbColor rgbColor = convertHsvToRgb(phase / 256.0, 1.0, 1.0);
                colors[i].red = rgbColor.red;
                colors[i].green = rgbColor.green;
                colors[i].blue = rgbColor.blue;
            }
            else
            {
                colors[i].red = 0;
                colors[i].green = 0;
                colors[i].blue = 0;
            }
        }

        _ledStrip.update(colors, count);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.015);
        }
    }
}

void TI_NEOPIXEL_SPI::moon(int count, int startIndex, int stopIndex, rgbColor c1, rgbColor c2)
{

    neopixel::Pixel colors[count];

    for (int j = 0; j < count; j++)
    {
        if (0 <= j && j <= count)
        {
            colors[j].red = c2.red;
            colors[j].green = c2.green;
            colors[j].blue = c2.blue;
        }
    }

    int loopCount = (stopIndex - startIndex) / 2;
    int middlePoint = startIndex + loopCount;

    for (int i = 0; i <= loopCount - 1; i++)
    {
        colors[middlePoint + i].red = c1.red;
        colors[middlePoint + i].green = c1.green;
        colors[middlePoint + i].blue = c1.blue;

        colors[middlePoint - i].red = c1.red;
        colors[middlePoint - i].green = c1.green;
        colors[middlePoint - i].blue = c1.blue;

        _ledStrip.update(colors, count);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.04);
        }
    }

    for (int i = 0; i <= loopCount - 1; i++)
    {
        colors[startIndex + i].red = c2.red;
        colors[startIndex + i].green = c2.green;
        colors[startIndex + i].blue = c2.blue;

        colors[stopIndex - i].red = c2.red;
        colors[stopIndex - i].green = c2.green;
        colors[stopIndex - i].blue = c2.blue;

        _ledStrip.update(colors, count);

        if (count == 16)
        {
            wait(0.05);
        }
        else
        {
            wait(0.04);
        }
    }
}

rgbColor TI_NEOPIXEL_SPI::convertHsvToRgb(float h, float s, float v)
{
    int i = floor(h * 6);
    float f = h * 6 - i;
    float p = v * (1 - s);
    float q = v * (1 - f * s);
    float t = v * (1 - (1 - f) * s);
    float r = 0, g = 0, b = 0;

    switch (i % 6)
    {
    case 0:
        r = v;
        g = t;
        b = p;
        break;
    case 1:
        r = q;
        g = v;
        b = p;
        break;
    case 2:
        r = p;
        g = v;
        b = t;
        break;
    case 3:
        r = p;
        g = q;
        b = v;
        break;
    case 4:
        r = t;
        g = p;
        b = v;
        break;
    case 5:
        r = v;
        g = p;
        b = q;
        break;
    }

    return (rgbColor){r * 255, g * 255, b * 255};
}