#ifndef MBED_TI_NEOPIXEL_SPI_H
#define MBED_TI_NEOPIXEL_SPI_H

#include "mbed.h"
#include "neopixel.h"

typedef struct rgbColor
{
  uint8_t red;
  uint8_t green;
  uint8_t blue;
} rgbColor;

class TI_NEOPIXEL_SPI
{
public:
  TI_NEOPIXEL_SPI(PinName input);

  void switchLightOff(int count);
  void switchLightOn(int count, int startCount, int endCount, rgbColor rgbColor);

  void changeColor(int count, int startCount, int endCount, rgbColor rgbColor);
  void changePointColor(int count, int topIndex, int endIndex, rgbColor topColor, rgbColor bottomColor);

  void circle(int count, int startCount, int endCount, rgbColor rgbColor);
  void chase(int count, int bufferCount, rgbColor c1, rgbColor c2);
  void chase2(int count, int bufferCount, rgbColor c1, rgbColor c2);
  void chaseReverse(int count, int bufferCount, rgbColor c1, rgbColor c2);

  void chaseRainbow(int count, int bufferCount);
  void circleRainbow(int count);

  void moon(int count, int startIndex, int stopIndex, rgbColor c1, rgbColor c2);

  rgbColor convertHsvToRgb(float h, float s, float v);

private:
  neopixel::PixelArray _ledStrip;
};

#endif