#ifndef MBED_TI_NEOPIXEL_H
#define MBED_TI_NEOPIXEL_H

#include "mbed.h"
#include "PololuLedStrip.h"

class TI_NEOPIXEL
{
public:
    TI_NEOPIXEL(PinName input);
    void switchLightOff(int count);
    void switchLightOn(int count);
    
    void changeColor(int count, rgb_color rgbColor);
    void changePointColor(int count, rgb_color topColor, rgb_color bottomColor);
    
    void circle(int count, rgb_color rgbColor);
    void circleRainbow(int count);
    rgb_color convertHsvToRgb(float h, float s, float v);

private:
    PololuLedStrip _ledStrip;
};

#endif
