#include "TI_NEOPIXEL.h"
#include "mbed.h"

TI_NEOPIXEL::TI_NEOPIXEL(PinName input) : _ledStrip(input) {
}

void TI_NEOPIXEL::switchLightOff(int count) {
    
    rgb_color colors[count];

    for(int i = 0; i < count; i++) {
        colors[i] = (rgb_color) {0, 0, 0};
    }
    
    _ledStrip.write(colors, count);
}

void TI_NEOPIXEL::switchLightOn(int count) {
    
    rgb_color colors[count];

    for(int i = 0; i < count; i++) {
        colors[i] = (rgb_color) {50, 10, 170};
    }
    
    _ledStrip.write(colors, count);
}

void TI_NEOPIXEL::changeColor(int count, rgb_color rgbColor) {
    
    rgb_color colors[count];

    for(int i = 0; i < count; i++) {
        colors[i] = rgbColor;
    }
    
    _ledStrip.write(colors, count);
}

void TI_NEOPIXEL::changePointColor(int count, rgb_color topColor, rgb_color bottomColor) {
    
    rgb_color colors[count];

    for(int i = 0; i < count; i++) {
        if (i == 0) {
            colors[i] = topColor;
        } else if (i == count/2) {
            colors[i] = bottomColor;
        } else {
            colors[i] = (rgb_color) {0, 0, 0};
        }
    }
    
    _ledStrip.write(colors, count);
}

void TI_NEOPIXEL::circle(int count, rgb_color rgbColor) {
    
    for(int j = 0; j < count; j++) {
        rgb_color colors[count];

        for(int i = 0; i < count; i++) {
            if (j >= i) {
                colors[i] = rgbColor;
            } else {
                colors[i] = (rgb_color) {0, 0, 0};
            }
        }
    
        _ledStrip.write(colors, count);
        wait(0.07);
    }
}

void TI_NEOPIXEL::circleRainbow(int count) {
    
    for(int j = 0; j < count; j++) {
        rgb_color colors[count];

        for(int i = 0; i < count; i++) {
            if (j >= i) {
                uint8_t phase = 256/count*i;
                colors[i] = convertHsvToRgb(phase / 256.0, 1.0, 1.0);
            } else {
                colors[i] = (rgb_color) {0, 0, 0};
            }
        }
    
        _ledStrip.write(colors, count);
        wait(0.07);
    }
}

rgb_color TI_NEOPIXEL::convertHsvToRgb(float h, float s, float v)
{
    int i = floor(h * 6);
    float f = h * 6 - i;
    float p = v * (1 - s);
    float q = v * (1 - f * s);
    float t = v * (1 - (1 - f) * s);
    float r = 0, g = 0, b = 0;
    
    switch(i % 6){
        case 0: r = v; g = t; b = p; break;
        case 1: r = q; g = v; b = p; break;
        case 2: r = p; g = v; b = t; break;
        case 3: r = p; g = q; b = v; break;
        case 4: r = t; g = p; b = v; break;
        case 5: r = v; g = p; b = q; break;
    }
    
    return (rgb_color){r * 255, g * 255, b * 255};
}