#include "mbed.h"
#include "neopixel.h"


NeoPixelOut neoPixel(p11);

int main() {
    wait(0.2); // wait for HSE to stabilize
    
    neoPixel.global_scale = 1.0f; // Adjust brightness
    neoPixel.normalize = true; // Equalize brightness to make r + g + b = 255
    
    Pixel pixels[6];
    pixels[0].hex = 0xFF0000;
    pixels[1].hex = 0xFFFF00;
    pixels[2].hex = 0x00FF00;
    pixels[3].hex = 0x00FFFF;
    pixels[4].hex = 0x0000FF;
    pixels[5].hex = 0xFF00FF;
    
    neoPixel.send(pixels, 6);
    
    while(1);
}