/***********************************************************************
* Read temperature by using DS1617
* read external diode temp. between DXP/DXN pin
* read on-chip temperature
* if changed then serial out
* end
* tested on nucleo-F401
************************************************************************/

#include "mbed.h"


#define MAX1617_RIT (0x00)  // internal temperature register
#define MAX1617_RET (0x01)  // external, (diode dxp-dxn)temperature register
#define MAX1617_ADDR (0x30) // MAX1617 address (ADD0=0  ADD1=0)
#define MAX1617_OSHT (0x0F) // MAX1617 one shot temperature read command, both channels


I2C i2c(I2C_SDA, I2C_SCL);

DigitalOut myled(LED1);

Serial pc(SERIAL_TX, SERIAL_RX);

int main()
{
   
    char data_read_1[1];    //temp extread holder
    char data_read_2[1];    //temp read holder
    int rispold_1=0;
    int rispold_2=0;

   
    while (1) {
       char command_one_shot[1] = {MAX1617_OSHT};
       char command_ext_temp[1] = {MAX1617_RET};
       char command_int_temp[1] = {MAX1617_RIT};
        //I2C transactions
        i2c.write(MAX1617_ADDR, command_one_shot , 1, 0); // no stop  //one shot temp read
        i2c.write(MAX1617_ADDR, command_ext_temp, 1, 1); // no stop   //ext temp read
        i2c.read(MAX1617_ADDR, data_read_1, 1, 0);
        i2c.write(MAX1617_ADDR, command_int_temp, 1, 1); // no stop   //int temp read
        i2c.read(MAX1617_ADDR, data_read_2, 1, 0);
        
        //
        int risp1 = (int)data_read_1[0];
        int risp2 = (int)data_read_2[0];
        if ((risp1 != rispold_1)|(risp2 != rispold_2))
          pc.printf("temp int = %d\n",  risp2);
           pc.printf("temp ext = %d\n",  risp1);
        rispold_1 = risp1;
        rispold_2 = risp2;
        myled = !myled;
        wait(0.3);
    }

}