/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/** @file main.cpp */
// Include header files for platform
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "segment_display.h"
#include <math.h>
#include <stdio.h>

// Include header files for missile command project
#include "globals.h"
#include "city_landscape_public.h"
#include "missile_public.h"
#include "player.h"

// Platform initialization
DigitalIn left_pb(p23); DigitalIn right_pb(p21); DigitalIn fire_pb(p22);DigitalIn fourth_pb(p24);
uLCD_4DGL uLCD(p28,p27,p29);
AnalogOut DACout(p18);
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sck, cs

// Example of the decleration of your implementation
void playSound(char * wav);

/** Main() is where you start your implementation
    @brief The hints of implementation are in the comments. <br>
    @brief You are expected to implement your code in main.cpp and player.cpp. But you could modify any code if you want to make the game work better.
*/
int main()
{   
    setup_sequence();
    seg_driver_initialize();
// playSound("/sd/wavfiles/BUZZER.wav");
    
    /// [Example of missile command implementation]
        /// Here is a rough flow to implement the missile command: <br><br>
    
    /// 1.Initialize and draw the city landscape
    city_landscape_init(4); 
    // Initialize the buttons        
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed    
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed        
    fire_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    fourth_pb.mode(PullUp);
    int x=60;
    int y=100;
    int count=0;
    int tem=0;
    int num_city=4;
    int life=3;
    int delta=10;
    int level=0;
    int num_missile=0;;
    int speed=0,interval=0,player_speed=0,pre_point=0;
    int t=0;
    CITY city;
    MISSILE missile,player_missile;
    /// 2.Begin the game loop
    int current_life;
    current_life=life_generate(life);
    //playSound("/sd/wavfiles/begin.wav");
    char begin[20];
    sprintf(begin,"%s" ,"Press PB4 To Start!");
    uLCD.text_string(begin,0,8,3,0xFF9900);
    while(1){
        if(fourth_pb==0){t=1;
        playSound("/sd/wavfiles/start.wav");
        uLCD.text_string(begin,0,8,3,BACKGROUND_COLOR);
        break;}}
    while(t){
        display_score(count);
        display_level(level);
        /// 3.Example of drawing the player
        player_draw(x,y); // draws a player at the center of the screen
        
        /// 4.Example of calling the missile API.
        missile_generator(); /// It updates all incoming missiles on the screen
        
        /// 5.Implement the code to get user input and update the player
            /// -[Hint] You could see city_landscape.cpp to get some ideas about how to implement your player. <br>
        if(left_pb == 0){
            if(x<=109){
            player_clear(x,y);
            x=x+3;
            player_draw(x,y);
            }
            /// -[Hint] Implement the code to move player left <br>
        }
        if(right_pb == 0){
            if(x>=3){
            player_clear(x,y);
            x=x-3;
            player_draw(x,y);
            }
            /// -[Hint] Implement the code to move player right <br>
        }
        
        //player_missile_generator(x, y);
        if(fire_pb == 0){
            while( fire_pb==0){
                }
            //implement the code to fire player-missile <br>
            player_missile_create(x+8, y-8.5);
            }
         if(fourth_pb==0&&num_missile<4){
                    while( fourth_pb==0){
                }
                    use_fourth_pb();
            }    
            
         if(left_pb==0&&right_pb==0){
            speed++;interval=interval+5;
            level++;
            advanced_level(8-speed%8,100-interval%100);
            }
        player_missile_update_position();
        int i,j,k;
        for (i=0; i<MAX_NUM_MISSILE;i++){
         missile=missile_get_info(i);
         if(abs(missile.x-x)<10 &&abs(missile.y-y)<10&&missile.status==MISSILE_ACTIVE||abs(missile.x-x-10)<10 &&abs(missile.y-y)<10&&missile.status==MISSILE_ACTIVE){
             missile_set_exploded(i);
             life--;
             life_reduce(current_life);
             current_life=current_life-7;
             
             }
             for(k=0;k<MAX_NUM_CITY;k++){
                 city=city_get_info(k);
                 if(missile.y<127-city.height){
                    if(abs(missile.x-city.x)<10 && abs(missile.y-city.y)<10 &&missile.status==MISSILE_ACTIVE&&city.status==EXIST){
                        missile_set_exploded(i);
                        city_destroy(k);
                        num_city--;
                        uLCD.filled_circle(missile.x , missile.y , 4, 0xCCAA00);
                         wait(0.4);
                        circle_explosion(missile.x , missile.y);
                        
                        uLCD.filled_circle(missile.x , missile.y , 4, BACKGROUND_COLOR);
                        //count=count-10;
                        display_score(count);
                        city_destory();
                        
                        
                        }
                        }
                else{
                    if(abs(missile.x-(city.x-5))<10&&missile.status==MISSILE_ACTIVE &&city.status==EXIST ||abs(missile.x-(city.x+5))<10&&missile.status==MISSILE_ACTIVE&&city.status==EXIST){
                        uLCD.filled_circle(missile.x , missile.y , 2, 0xCCAA00);
                        missile_set_exploded(i);
                        city_destroy(k);
                        num_city--;
                        uLCD.filled_circle(missile.x , missile.y , 4, 0xCCAA00);
                         wait(0.4);
                        circle_explosion(missile.x , missile.y);
                        uLCD.filled_circle(missile.x , missile.y , 4, BACKGROUND_COLOR);
                        //count=count-10;
                        display_score(count);
                        city_destory();
                        
                        }
                 }
                 }
         for(j=0; j<MAX_NUM_PLAYER_MISSILE;j++){
             
            player_missile=player_missile_get_info(j);
            int radius_x=abs(missile.x-player_missile.x);
            int radius_y=abs(player_missile.y-missile.y);
            if(radius_x<delta &&radius_y<delta){
                
                //delta can change depend on current level
                if(missile.status==MISSILE_ACTIVE &&player_missile.status==MISSILE_ACTIVE){
                    uLCD.filled_circle(missile.x , missile.y , 2, 0xC90000);
                    
                    missile_set_exploded(i);
                    player_missile_set_exploded(j);
                    wait(0.2);
                    uLCD.filled_circle(missile.x , missile.y , 2, BACKGROUND_COLOR);
                    interval=interval+5;
                    set_missile_interval(interval);
                    count++;
                    display_score(count);
                    point_get();
  
                    
                    }//if              
             
                }//if
                
            }//for j
        }//for i
       
        /// 9.Implement the code to check the end of game
            /// -[Hint] For example, if there is no more city, it should be gameover. <br>
            num_missile=num_missile_avi(tem);
            seg_driver(5-num_missile%6);
            //||num_city==0
            if (life==-1||num_city==0){
                 //player_clear(x,y);
                break;}
        if(count%10==0 && count!=0&&count>pre_point){
            player_set_missile_speed((8-player_speed%8));
            char level_up[10];
            sprintf(level_up,"%s" ,"Level up");
            uLCD.text_string(level_up,0,8,3,0xFF9900);
            wait(0.3);
            
            uLCD.text_string(level_up,0,8,3,BACKGROUND_COLOR);
            char speed_up[10];
            sprintf(speed_up,"%s" ,"Speed up");
            uLCD.text_string(speed_up,0,8,3,0xFF9900);
            wait(0.2);
            uLCD.text_string(level_up,0,8,3,BACKGROUND_COLOR);
            playSound("/sd/wavfiles/level.wav");
            speed++;interval=interval+5;
            level++;
            advanced_level(8-speed%8,100-interval%100);
            pre_point=count;
            }
    }  //while  
    uLCD.text_char('g', 6, 2, 0xCCAA00);    uLCD.text_char('a', 7, 2, 0xCCAA00);    uLCD.text_char('m', 8, 2, 0xCCAA00); uLCD.text_char('e', 9, 2, 0xCCAA00);
    uLCD.text_char('o', 6, 4, 0xCCAA00);uLCD.text_char('v', 7, 4, 0xCCAA00);uLCD.text_char('e', 8, 4, 0xCCAA00);uLCD.text_char('r', 9, 4, 0xCCAA00);
playSound("/sd/wavfiles/end.wav");
}//main

// Example of implementation of your functions
void playSound(char * wav)
{
    // open wav file
    FILE *wave_file;
    wave_file=fopen(wav,"r");

    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}
