/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 
// Template of player header file
#ifndef PLAYER_H
#define PLAYER_H

// Example of some player settings
#define PLAYER_WIDTH   10 
#define PLAYER_HEIGHT  3
#define PLAYER_DELTA   3
#define PLAYER_COLOR   0x4DB849
#include "missile_public.h"
//#include "missile_public.h"

/** Get the information of city
    @brief x and y are the top left corner of the player drawing
    @param x x-coordinate
    @param y y-coordinate
*/
 #define MAX_NUM_PLAYER_MISSILE  5

void player_draw(int x, int y);
void player_clear(int x_clear,int y_clear);
void player_missile_create(int x2,int y2);
void player_missile_update_position(void);
void player_missile_draw(MISSILE missile, int color);
void player_missile_generator(int x1, int y1);
MISSILE player_missile_get_info(int index);
void player_missile_set_exploded(int index);
void player_set_missile_speed(int speed);
void life_reduce(int x);
int life_generate(int life);
int num_missile_avi(int x);
void city_destory();
void point_get();
void display_score(int x);
void advanced_level(int speed, int interval);
void display_level(int x);
void circle_explosion(int x,int y);
void use_fourth_pb();

#endif //PLAYER_H