/* Gatech ECE2035 2014 FALL missile command
 * Copyright (c) 2014 Gatech ECE2035
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef GLOBAL_H
#define GLOBAL_H

// === [global object] ===
extern uLCD_4DGL uLCD;


// === [global settings] ===
#define BACKGROUND_COLOR 0x000000 //black
#define LANDSCAPE_HEIGHT 4        // number of pixel on the screen
#define MAX_BUILDING_HEIGHT 10    // number of pixel on the screen


// === [define the macro of error heandle function] ===
// when the condition (c) is not true, assert the program and show error code
#define ASSERT_P(c,e) do { \
    if(!(c)){ \
        uLCD.printf("\nERROR:%d\n",e); \
        while(1); \
    } \
} while (0)


// === [error code] ===
#define ERROR_MISSILE_INDEX_GET_INFO      -1  // make sure your code give the valid index for missile_get_info()
#define ERROR_MISSILE_INDEX_UPDATE_STATUS -2  // make sure your code give the valid index for missile_update_status()
#define ERROR_MISSILE_SPEED               -3  // missile speed has to be between 1 and 8
#define ERROR_MISSILE_INTERVAL            -4  // missile interval has to be between 1 and 100
// other missile error code ...
#define ERROR_CITY_NUMBER                 -11 // num_city in city_landscape_init() is larger than MAX_NUM_CITY
#define ERROR_CITY_INDEX_GET_INFO         -12 // make sure your code give the valid index for city_get_info()
#define ERROR_CITY_INDEX_DESTROY          -13 // make sure your code give the valid index for city_destroy()
// other player-missile error code ...

#endif //GLOBAL_H