

// Template of player implementation
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "globals.h"
#include "player.h"
#include "missile_public.h"
#include "city_landscape_public.h"
#define pi 3.14159265
void player_draw(int x, int y) {
    uLCD.circle(x+2,y,2,0x58C1FD);
    uLCD.circle(x+14,y,2,0x58C1FD);
    uLCD.rectangle(x+4, y-1.5, x+12, y+1.5, 0xECE9D8); 
    uLCD.triangle(x+2,y-1.5, x+12, y-1.5,x+9,y-8.5,0xECE9D8);
    //uLCD.filled_rectangle(x+PLAYER_DELTA, y-PLAYER_DELTA, x+PLAYER_WIDTH-PLAYER_DELTA, y+PLAYER_HEIGHT, PLAYER_COLOR);  
}
void player_clear(int x,int y){
    uLCD.circle(x+2,y,2,BACKGROUND_COLOR);
    uLCD.circle(x+14,y,2,BACKGROUND_COLOR);
    uLCD.rectangle(x+4, y-1.5, x+12, y+1.5, BACKGROUND_COLOR); 
    uLCD.triangle(x+2,y-1.5, x+12, y-1.5,x+9,y-8.5,BACKGROUND_COLOR);
    //uLCD.filled_rectangle(x, y, x+PLAYER_WIDTH, y+PLAYER_HEIGHT, BACKGROUND_COLOR); 
    //uLCD.filled_rectangle(x+PLAYER_DELTA, y-PLAYER_DELTA, x+PLAYER_WIDTH-PLAYER_DELTA, y+PLAYER_HEIGHT, BACKGROUND_COLOR);  
    }
// ... You need to implement your own functions for player ...











MISSILE player_missile_record[MAX_NUM_PLAYER_MISSILE];
int player_missile_tick=1;
int player_missile_interval = 17;
int player_missile_speed = 8;
int num_missile=0;
void player_missile_generator(int x, int y){
    player_missile_tick++;
    // only fire the missile at certain ticks
    if((player_missile_tick % player_missile_interval)==0 || player_missile_tick==1){
        player_missile_create(x,y);
    }

    // update the missiles and draw them
    player_missile_update_position();
}

void player_set_missile_speed(int speed){
    ASSERT_P(player_missile_speed>=1 && player_missile_speed<=8,ERROR_MISSILE_SPEED);
    if(player_missile_speed>=1 && player_missile_speed<=8){  
        player_missile_speed = speed;
    }
}

// set missile interval (default interval is 10)
void player_set_missile_interval(int interval){
    ASSERT_P(player_missile_interval>=1 && player_missile_interval<=100,ERROR_MISSILE_INTERVAL);
    if(player_missile_interval>=1 && interval<=100){
        player_missile_interval = interval;
    }
}



void player_missile_create(int current_x, int intcurrent_y){
    int i;
    for(i=0;i<MAX_NUM_PLAYER_MISSILE;i++){
        if(player_missile_record[i].status == MISSILE_DEACTIVE){

            player_missile_record[i].y = 97;
            //each missile has its own tick
            player_missile_record[i].tick = 0;
            //missile_record[i].tick = missile_tick;
            //set a random source for the missile
            player_missile_record[i].source_x = current_x;
            player_missile_record[i].source_y = 97;
            //set a random target for the missile
            player_missile_record[i].target_y = 0;
            player_missile_record[i].target_x = current_x;
            //player_missile_record[i].y = player_missile_record[i].source_y;
            player_missile_record[i].status = MISSILE_ACTIVE;
            num_missile++;
            break;
        }
    }
}











void player_missile_update_position(void){
    int i;
    player_missile_tick++;
    //controls how fast the missile will move
    //int rate = player_missile_speed * 25;
    int rate = player_missile_speed  * 25;
    //delta_x and delta_y account for the slope of the missile
    double delta_y;
    for(i=0;i<MAX_NUM_PLAYER_MISSILE;i++){
        if(player_missile_record[i].status == MISSILE_ACTIVE){
            // update missile position
            //delta_x = (player_missile_record[i].target_x - player_missile_record[i].source_x)/rate;
            delta_y = -200/rate;
            player_missile_draw(player_missile_record[i], BACKGROUND_COLOR);
            //player_missile_record[i].x = player_missile_record[i].source_x;
            player_missile_record[i].y = (int)(player_missile_record[i].source_y + delta_y*(player_missile_record[i].tick%rate));
           // player_missile_record[i].y = (int)(delta_y*(player_missile_record[i].tick%rate));
            player_missile_record[i].x = (int)(player_missile_record[i].source_x);
            
            // draw missile
            player_missile_draw(player_missile_record[i], 0x508ADF);
            player_missile_record[i].tick++;
            //draw_landscape();
            //update missile's internal tick
            if (player_missile_record[i].tick==rate){
                player_missile_record[i].status= MISSILE_DEACTIVE;
                
                player_missile_record[i].tick = 0;
                num_missile--;
                }
            //player_missile_record[i].tick++;
        }       
        else if(player_missile_record[i].status == MISSILE_EXPLODED){
            // clear the missile on the screen
            
            player_missile_draw(player_missile_record[i], BACKGROUND_COLOR);
            
            // we have done with this missile, remove it from record
            player_missile_record[i].status = MISSILE_DEACTIVE;
            //resets the missile's internal tick
            player_missile_record[i].tick = 0;
            num_missile--;
        }
        
    }
}

MISSILE player_missile_get_info(int index){
    // All interface for user should have error checking
    ASSERT_P(index<MAX_NUM_PLAYER_MISSILE,ERROR_MISSILE_INDEX_GET_INFO);
    
    return player_missile_record[index];
}


void player_missile_set_exploded(int index){
    // All interface for user should have error checking
    ASSERT_P(index<MAX_NUM_PLAYER_MISSILE,ERROR_MISSILE_INDEX_UPDATE_STATUS);
    
    player_missile_record[index].status = MISSILE_EXPLODED;
}


void player_missile_draw(MISSILE player_missile, int color){
    int init_x,init_y,current_x,current_y;

    init_x = player_missile.source_x;
    init_y = 100;
    current_x = player_missile.x;
    current_y = player_missile.y;
    uLCD.line(init_x, init_y, current_x, current_y, color);
}

void life_reduce(int x){
    uLCD.circle(x ,  5 , 3, BACKGROUND_COLOR);
    }
    
int life_generate(int life){
    int i;int x_=0;;
    for(i=0;i<life;i++){
        x_=5+7*i;
    uLCD.circle( x_,  5 , 3, 0x508ADF);
    }
    
    return x_;
}
int num_missile_avi(int x){
    x= num_missile;
    return x;
    }
void city_destory(){
    uLCD.text_char('-', 13, 6, 0xCCAA00); 
    uLCD.text_char('1', 14, 6, 0xCCAA00);
     uLCD.text_char('0',15, 6, 0xCCAA00); 
    
    wait(0.3);
    uLCD.text_char('-', 13, 6, BACKGROUND_COLOR); 
    uLCD.text_char('1', 14, 6, BACKGROUND_COLOR); 
    uLCD.text_char('0', 15, 6, BACKGROUND_COLOR); 
    }
void point_get(){
    uLCD.text_char('+', 13, 6, 0xCCAA00); 
    uLCD.text_char('1', 14, 6, 0xCCAA00); 
    wait(0.3);
    uLCD.text_char('-', 13, 6, BACKGROUND_COLOR); 
    uLCD.text_char('1', 14, 6, BACKGROUND_COLOR);
    }
void display_score(int x){
    char str[8];
    sprintf(str, "%d", x);
    uLCD.text_string(str,15,1,3,0xFF9900);
    }
 void advanced_level(int speed, int interval){
    set_missile_interval(interval);
    set_missile_speed( speed);
    }
void display_level(int x){
    char str[2];
    sprintf(str, "%d", x);
    uLCD.text_string(str,0,3,3,0xFF9900);
    }
void circle_explosion(int x,int y){
    int angle=0;
    for(angle=0;angle<=360;angle=angle+20){
    int delta_x=4*cos(angle*pi/180);
    int delta_y=4*sin(angle*pi/180);
    uLCD.filled_circle(x+delta_x-2 , y+delta_y-2 , 2, 0xECE9D8);
    wait(0.15);
    uLCD.filled_circle(x+delta_x-2 , y+delta_y-2 , 2, BACKGROUND_COLOR);
                        }
    }
    
    void use_fourth_pb(){
    char str[10];
    sprintf(str, "%s", "super bomb");
    uLCD.text_string(str,5,3,3,0xECE9D8);
    wait(0.25);
    uLCD.text_string(str,5,3,3,BACKGROUND_COLOR);
    int i;
    MISSILE missile;
    for(i=0;i<5;i++){
        
        missile=missile_get_info(i);
        if(missile.status == MISSILE_ACTIVE){
            
            uLCD.filled_circle(missile.x ,missile.y, 2, 0xECE9D8);
            wait(0.2);
            uLCD.filled_circle(missile.x ,missile.y, 2, BACKGROUND_COLOR);
            missile_set_exploded(i);
            }
    }
    }