#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "motordriver.h"
DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
AnalogIn pot(p20);

LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HTTPServer svr;

// Magician robot motor test

//Connections to dual H-brdige driver for the two drive motors
Motor  left(p21, p22, p23, 1); // pwm, fwd, rev, has brake feature


int main() {
  Base::add_rpc_class<DigitalOut>();

  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
  FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RPCHandler>("/rpc");
  svr.addHandler<FSHandler>("/files");
  svr.addHandler<FSHandler>("/"); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
  
  svr.bind(80);
  
  printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  
  float speed;
  while(true)
  {     
    Net::poll();
    speed = pot.read();
    if(led1==1){
       left.speed(speed);
       led1=0;
        //start    
    }
    else if(led2 ==1){
        //stop 
        left.speed(0);
        led2=0;
    }
    else if(led3==1){
        //reverse        
        left.speed(-speed);  
        led3 =0;
    }
    
    if(tm.read()>.5)
    {
      led4=!led4; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;

}
