#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"

DigitalOut led(LED1);
LM75B tsensor(D14,D15);
AnalogIn pot (A0);

int main()
{
    printf("Client example\n\r");

    EthernetInterface eth;
    eth.set_network("192.168.0.39","255.255.255.0","192.168.0.1");
    eth.connect();
    printf("The client IP address is '%s'\n\r", eth.get_ip_address());


    TCPSocket socket;

    socket.open(&eth);
    socket.connect("192.168.0.23",4000);

    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("received: %d\r\n", rcount);
    printf(rbuffer);

    uint16_t temp = tsensor.read();
    char upperbyte = (temp >> 8) & 0xFF;
    char lowerbyte = temp & 0xFF;

    char data[4];
    data[0] = upperbyte;
    data[1] = lowerbyte;
    data[2] = (char)((pot*255);
    data[3] = (char)(34);

    socket.send(data, 4);

    socket.close();


}