#include "mbed.h"
#include "usart.h"
#include "drive.h"
#include "mpid.h"
//#include "rtos.h"

#define RATE 0.1

PID controller1(-2.5, 0.0, 0.0, RATE);
PID controller2(-1.0, 0.0, 0.0, RATE);

//PID controller1(-1.0,0.0,0.0,0.0,0.0,2000.0);

extern float a1[3],w1[3],angle1[3],T1;
extern float a2[3],w2[3],angle2[3],T2;
//float angle_pre[3] = {0, 0, 0};


//extern unsigned char data;
bool sw_motor1=1;
bool sw_pid1=0,sw_pid2=0;
bool sw_stop1=0,sw_stop2=0;
bool sw_timeout = 0;
int direction_first=0;

Serial pc(USBTX, USBRX);

//Timeout flipper;

extern DigitalOut dir;
//extern Serial usart;
void motor_angle(void);
void pid1(bool pid1_intr,float pid1_input);
void pid2(bool pid2_intr,float pid2_input);
void motor_angle_0(void);
void motor_angle_2(void);
void callback();

//    flipper.attach(&flip, 0.02); // setup flipper to call flip after 2 seconds
//void flip(){
//	sw_timeout=1;
//}

//void serial_thread(void const *args) {
//    while (true) {
//        USART2_INIT_ser();
//        Thread::wait(RATE);
//    }
//}
int main()
{
	
	controller1.setInputLimits(0, 15.0);
	//Pwm output from 0.0 to 1.0
	controller1.setOutputLimits(0.0, 2000.0);
	//If there's a bias.
	controller1.setBias(0);
	controller1.setMode(AUTO_MODE);
	//We want the process variable to be 1.7V
	controller1.setSetPoint(0.0);
	
	controller2.setInputLimits(0, 40.0);
	//Pwm output from 0.0 to 1.0
	controller2.setOutputLimits(0.0, 2000.0);
	//If there's a bias.
	controller2.setBias(0);
	controller2.setMode(AUTO_MODE);
	//We want the process variable to be 1.7V
	controller2.setSetPoint(0.0);
	
//	sw_motor1=1;
//	jog_release();
//	motor_initial();
	pc.baud(9600);
	int baud = 9600;  
	USART_INIT(baud);
	motor_initial();
//	Thread thread(serial_thread);
	//flipper.attach(&flip,RATE);
	while(true) {
		//flipper.attach(&flip,RATE);
//		if(sw_timeout==1){
			//sw_timeout=0;
			motor_drive();
			USART_INIT_ser();
//			USART2_INIT_ser();
			if(fabs(angle1[1])<6){
				sw_motor1=1;}
			motor_angle();
			motor_angle_0();
			motor_angle_2();
	//      pc.printf("(%f, %f, %f, %f, %f)\n",jdg[0],jdg[1],jdg[2],jdg[3],jdg[4]);			//测试连续输出y的角度
	//      pc.printf("ax=%f, ay=%f, az=%f\n",a[0],a[1],a[2]);
	//      pc.printf("wx=%f, wy=%f, wz=%f\n",w[0],w[1],w[1]);
			//差值过大则去除
	//		for (int i = 0; i < 3; i++) {
	//			if (angle_pre[i] - angle[i] > 10 ||angle_pre[i] - angle[i] < -10) {
	//				continue;
	//			}
	//			angle_pre[i] = angle[i];
	//		}
	
	//		pc.printf("1anglex=%f,angley=%f,anglez=%f)\n",angle1[0],angle1[1],angle1[2]);
	//		pc.printf("2anglex=%f,angley=%f,anglez=%f)\n",angle2[0],angle2[1],angle2[2]);
	       
			pc.printf("angle1y=%f,sw_pid1=%d,angle2y=%f\n",angle1[1],sw_pid1,angle2[1]);
	//		pc.attach(&callback);
			pid1(sw_pid1,fabs(angle1[1]));
			pid2(sw_pid2,fabs(angle2[1]));
		    wait(RATE);
		}
//	}
}

void motor_angle(){
	if(sw_motor1==1){
		if(angle1[1]>6){
			wait(3);
			if(angle1[1]>6){
				rev_falling();
				direction_first=1;
				sw_motor1=0;
				wait(0.1);
				sw_pid1=1;
			}
		}
		if(angle1[1]<-6){
			wait(3);
			if(angle1[1]<-6){
				jog_falling();
				direction_first=2;
				sw_motor1=0;
				wait(0.1);
				sw_pid1=1;
			}
		}
		return;
	}
};

//pid1 for vertual control;
void pid1(bool pid1_intr, float pid1_input){
	if(pid1_intr==1){
		sw_stop1=1;
		sw_stop2=0;
		float pwm_period1;
		controller1.setProcessValue(pid1_input);
    	//Set the new output.
    	pwm_period1= controller1.compute();
    	set_PWM_f(pwm_period1);
//    	pc.printf("period=%f\n",pwm_period1);
	}
	return;
};

void pid2(bool pid2_intr, float pid2_input){
	if(pid2_intr==1){
		sw_stop1=0;
		sw_stop2=1;		
		switch(direction_first){
			case 1:
				jog_falling();
				direction_first=0;
				break;
			case 2:
				rev_falling();
				direction_first=0;
				break;
			default:
				break;
		}
		float pwm_period2;
		controller2.setProcessValue(pid2_input);
    	//Set the new output.
    	pwm_period2= controller2.compute();
    	set_PWM_f(pwm_period2);
//    	pc.printf("period=%f\n",pwm_period1);
	}
	return;
};


void motor_angle_0(){
	if(sw_stop1==1){
		if(fabs(angle1[1])<0.1f){
			motor_stop();
			sw_pid1=0;
			wait(0.1);
			sw_pid2=1;
		}
	}
	return;
};

void motor_angle_2(){
	if(sw_stop2==1){
		if(fabs(angle2[1])<0.1f){
			motor_stop();
			sw_pid2=0;
			sw_stop2=0;
//			direction_first=0;
		}
	}
	return;
};
	
void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    char instr=pc.getc();
    change_speed(instr);
    return;
};	
