// php_acces main.cpp
 
#include "mbed.h" 
#include "EthernetInterface.h"
#include "HTTPClient.h"
#define BUFF_SIZE 128

extern void php_access_main( char *uri, char *ch_name, int* sp );
char php_uri[]="https://alpha.c.dendai.ac.jp/plot_auth/save_data.php"; 

char ch_str[] ="ch13894";

extern HTTPClient http;
EthernetInterface eth;

static int speed=0;
void thread_main( void const *av ){
    char ch_name[BUFF_SIZE];
    strcpy( ch_name, ch_str );
    printf( "Channel Name:%s\n", ch_name );
    
    php_access_main( php_uri, ch_name, &speed ); // 
    
    while(true) Thread::wait(1000);
}

// memo
// R-LED -> LED1; G-LED -> LED2; B-LED -> LED3;
// sw3 -> PTA4; sw2 -> PTC6;

DigitalOut my_LED0(LED1);
DigitalOut my_LED1(LED3);
DigitalOut my_LED2(LED2);
DigitalIn  my_sw0(PTA4); 
DigitalIn  my_sw1(PTC6); 

int main() {
    my_LED0=1;
    my_LED1=1;
    Timer t;
    t.start();
    
    int ret = eth.init(); //Use DHCP
    printf( "php_test Starting,...\n" ) ;
    while(1) {
        ret = eth.connect();
        if( ret==0 )break ; // DHCP OK
        Thread::wait( 100 );
    }
    t.stop();
    srand(t.read_ms());

    printf( "IP = %s\n", eth.getIPAddress() );
    
    #define STACK_SIZE 20000
    Thread thr( thread_main, NULL, osPriorityNormal, STACK_SIZE );
    speed=0;
    int i=0;
    while(true){
        if(!my_sw0 && speed<=0)speed++;
        if(!my_sw1 && speed>=0)speed--;
        if(speed>0 ){my_LED0=0;my_LED1=1;my_LED2=1;}
        if(speed<0 ){my_LED0=1;my_LED1=0;my_LED2=1;}
        if(speed==0){my_LED0=1;my_LED1=1;my_LED2=0;}
        speed = (rand()%3)-1;
        Thread::wait(1000);
        i++;
    }
}

