// http_access  main.cpp
#include "mbed.h"
#include "EthernetInterface.h"

#define PORT 80 /*** SSL 443 ***/ 

#define err_sys(m) puts(m)

TCPSocketConnection socket;


EthernetInterface eth;

void net_main(void const *av)
{
    char server_ip[20] ;

    eth.init(); //Use DHCP
    printf("===== Simple TCP Client ========\n") ;
    
    while(1) {
        if(eth.connect()== 0)break ;
        wait(0.1);
    }
    printf("Client IP: %s\n", eth.getIPAddress());


    socket.set_blocking(false, 300) ;
    printf("Server IP: ") ;
    for(int i=0; i<sizeof(server_ip); i++) {
        if((server_ip[i] = getchar()) == '\r') {
            server_ip[i] = '\0' ;
            putchar('\n') ;
            break ;
        } else putchar(server_ip[i]) ;
    }
    
    while (socket.connect(server_ip, PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", server_ip, PORT);
        wait(1);
    }
    printf("TCP Connected\n") ;

    char msg[] = "GET /congrats.html  HTTP/1.0\r\nConnection: Close\r\n\r\n" ;
    // const char msg[] = "Hello World\r\n" ;

    if (
        socket.send(msg, sizeof(msg)-1) != (sizeof(msg)-1))
        err_sys("CyaSSL_write failed");

    char buf[1024];
    int n ;
    puts("Server Response:\n") ;
    do {
        n = socket.receive(buf, sizeof(buf)-1);
        if (n >= 0) {
            buf[n] = 0;
            printf("%s", buf);
        } else break ;
    } while(n > 0) ;
    puts("=== === === ===") ;
    socket.close();
    eth.disconnect();
}

main(){
 
#define STACK_SIZE 20000
    Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);
 
    while (true) {
        Thread::wait(1000);
    }
}
