// dropbox_access main.cpp
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"


//#define SHARED_LINK "https://www.dropbox.com/s/m856g2irwzb68uv/test.txt?dl=0"
#define SHARED_LINK "https://www.dropbox.com/s/gtard2k48f2y8yy/test.txt?dl=0"


extern HTTPResult dropbox_get(const char *url, char *buff, int size) ;

EthernetInterface eth;
HTTPClient http;
char recvBuff[1024*20];

int main(){
    
    HTTPResult ret ;
    
    eth.init(); //Use DHCP
    printf( "Dropbox Shared Link, Starting,...\n" ) ;
    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }
    printf("HTTP Client, IP Address is %s\n", eth.getIPAddress() );
    printf("Shared Link: %s\n", SHARED_LINK);
    
    memset( recvBuff, '\0', sizeof(recvBuff) );
    ret = dropbox_get( SHARED_LINK, recvBuff, sizeof(recvBuff) );
    if (ret == HTTP_OK) {
        printf( "Result: %s\n", recvBuff );
    } else {
        printf( "Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode() );
    }
    eth.disconnect();

    while(1) {
    }
}
