#include "HTTPServer.h"

#include "webpage.h"
#include "mbed.h"

#define INVALID_FORMATTER "No valid formatter specified"

#define HTPPRECEIVERGETOK   8

#define HTTPCTRREDON        1
#define HTTPCTRREDOFF       2
#define HTTPCTRGREENON      3
#define HTTPCTRGREENOFF     4
#define HTTPCTRBLUEON       5
#define HTTPCTRBLUEOFF      6
#define HTTPCTRLEADSTATE    7
#define HTTPBUTTONPRESS     10

#define STRING_LED_LENGTH  8
#define LED_STT(x)      x?"ON":"OF"
#define BUTTON_STT(x)      x?"ON":"OF"

static unsigned char LedRed = 0, LedGreen = 0, LedBlue = 0;
extern unsigned char button;

const char RespondOnRed[] = {"HTTP/1.1 200 OK\r\n"
                             "Server: AVR_Small_Webserver\r\n"
                             "WWW-Authenticate: Basic realm=\"NeedPassword\""
                             "\r\nContent-Type: text/html\r\n\r\n"
                             "ONRED"};
const char RespondOnGreen[] = {"HTTP/1.1 200 OK\r\n"
                               "Server: AVR_Small_Webserver\r\n"
                               "WWW-Authenticate: Basic realm=\"NeedPassword\""
                               "\r\nContent-Type: text/html\r\n\r\n"
                               "ONGREEN"};
const char RespondOnBlue[] = {"HTTP/1.1 200 OK\r\n"
                              "Server: AVR_Small_Webserver\r\n"
                              "WWW-Authenticate: Basic realm=\"NeedPassword\""
                              "\r\nContent-Type: text/html\r\n\r\n"
                              "ONBLUE"};
const char RespondOff[] = {"HTTP/1.1 200 OK\r\n"
                           "Server: AVR_Small_Webserver\r\n"
                           "WWW-Authenticate: Basic realm=\"NeedPassword\""
                           "\r\nContent-Type: text/html\r\n\r\n"
                           "OFF"};
const char ResponseHdr[] = {"HTTP/1.1 200 OK\r\n"
                           "Server: AVR_Small_Webserver\r\n"
                           "WWW-Authenticate: Basic realm=\"NeedPassword\""
                           "\r\nContent-Type: text/html\r\n\r\n"};

DigitalOut ledRed(LED1);
DigitalOut ledGreen(LED2);
DigitalOut ledBlue(LED3);

bool cmp(char* a, char* b)
{
    return strcmp(a,b) < 0;
}

HTTPServer::HTTPServer():
socket(),
handlers(&cmp),
reply(),
flagHTTP(),
command()
{
}

HTTPServer::~HTTPServer()
{
    for(std::map<char*, RequestHandler*>::iterator itor = handlers.begin();
        itor != handlers.end();
        ++itor)
        delete itor->second;

   // if(formatter)
//        delete formatter;
}

void HTTPServer::ledinit(void)
{
    ledRed = 1 ;
    ledGreen = 1;
    ledBlue = 1;
}

int HTTPServer::findstr(char *progstr,char* str,int len)
{
    uint16_t i,j;

    i=0;
    j=0;
    while(i<len){
        if(str[i++] != *(progstr + j++)){
            j = 0;
        }
        if(*(progstr + j) == 0){
            return(i-j);
        }
    }
    return(0xFFFF);
}

bool HTTPServer::init(int port)
{
    socket.set_blocking(true);
    if(socket.bind(port))
    {
        printf("Could not bind on port %d.\n", port);
        return false;
    }

    if(socket.listen())
    {
        printf("Could not listen %d\n", port);
        return false;
    }

    return true;
}

int HTTPServer::LedState_str(char* str_Led, unsigned char Red, unsigned char Green, unsigned char Blue)
{
    char str_mp[15];
    int str_len;
    sprintf(str_mp, "%s %s %s", LED_STT(Red), LED_STT(Green), LED_STT(Blue));
    sprintf(str_Led,"%s%s", ResponseHdr,str_mp);
    str_len = sizeof(ResponseHdr) + STRING_LED_LENGTH;//STRING_LED_LENGTH: String response length with 2 space
    return str_len;
}

int HTTPServer::ButtonState_str(char* str_Led, unsigned char button)
{
    int str_len;
    sprintf(str_Led,"%s%s", ResponseHdr,BUTTON_STT(button));
    str_len = sizeof(ResponseHdr) + 2;
    return str_len;
}

void HTTPServer::run()
{
    char str_LED_State[150];
    char str_State1[150];

    TCPSocketConnection c;
    while(true)
    {
        while(socket.accept(c));
        c.set_blocking(false, 10);
        while(c.is_connected())
        {
            char buffer[512];
            int n = c.receive_all(buffer, sizeof(buffer)-1);
            if(n == 0)
            {
                c.close();
                break;
            }
            else if(n != -1)
            {
                buffer[n] = '\0';
                handle_request(buffer);
                if(!strcmp(reply,"GET"))
                {
                    c.send(RespondGetOK, strlen(RespondGetOK)+1);
                    c.send(Page3, strlen(Page3)+1);
                }
                else if(!strcmp(reply,"load"))
                    c.send(str_LED_State, LedState_str(str_LED_State, LedRed,LedGreen,LedBlue));
                else if(!strcmp(reply,"LEDRED=ON"))
                {   ledRed = 0; //led on board
                    c.send(RespondOnRed,sizeof(RespondOnRed));
                    LedRed = 1;
                }
                else if(!strcmp(reply,"LEDRED=OFF"))
                {   
                    ledRed = 1;
                    c.send(RespondOff,sizeof(RespondOff));
                    LedRed = 0;
                }
                else if(!strcmp(reply,"LEDGR=ON")){
                        ledGreen = 0;
                        c.send(RespondOnGreen,sizeof(RespondOnGreen));
                        LedGreen = 1;
                }
                else if(!strcmp(reply,"LEDGR=OFF")){
                        ledGreen = 1;
                        c.send(RespondOff,sizeof(RespondOff));
                        LedGreen = 0;
                }
                else if(!strcmp(reply,"LEDBLUE=ON")){
                    ledBlue = 0;
                    c.send(RespondOnBlue,sizeof(RespondOnBlue));
                    LedBlue = 1;
                }
                else if(!strcmp(reply,"LEDBLUE=OFF")){
                        ledBlue = 1;
                        c.send(RespondOff,sizeof(RespondOff));
                        LedBlue = 0;
                }
                else if(!strcmp(reply,"isbuttonpress")){
                        c.send(str_State1,ButtonState_str(str_State1, button));
                }
                else{
                    printf("%s\r\n",reply);
                }
/*                if(formatter != NULL)
                {
                    printf("Sending data...");
                    char *page = formatter->get_page(reply);
                    do
                    {
                        c.send(page, strlen(page)+1);
                        page = formatter->get_page(reply);
                    }while(strlen(page)>0);
                    c.send(Page3, strlen(Page3)+1);
                    printf("done\n");
                }
                else{
                    printf("Format NULL");
                    c.send(INVALID_FORMATTER, strlen(INVALID_FORMATTER)+1);
                }*/
            }
            else{}
                //printf("Error while receiving data\n");
        }
    }
}

void HTTPServer::handle_request(char *buffer)
{
    char *request_type = strtok(buffer, " ");
    char *request = strtok(NULL, " ");
    char *statusrequest = strtok(request, "?");

    //printf("%s\r\n",request_type);
    //printf("%s\r\n",request);
    //printf("%s\r\n",statusrequest);
    reply[0] = '\0';
    //flagHTTP = 0;
    // GET paket
    if(!strcmp(request_type, "GET")){
        if(!strcmp(request, "/")){
            strcat(reply,"GET");
            return;
        }
        else if(!strcmp(statusrequest, "/acloadstate")){
            strcat(reply,"load");
            return;
        }
        else{}
    }
    // POST packet
    else if(!strcmp(request_type, "POST")){
        ++statusrequest;
        strcat(reply,statusrequest);
        return;
    }
    else
        strcat(reply,"receive not useful data");
}

void HTTPServer::add_request_handler(char *name, RequestHandler* handler)
{
    handlers[name] = handler;
}

