#ifndef HTTP_SERVER
#define HTTP_SERVER

#include <map>

#include "mbed.h"
//#include "mbed_rpc.h"
#include "RequestHandler.h"

#include "EthernetInterface.h"
#include "RPCCommand.h"


class HTTPServer
{
    public :
    
        HTTPServer();
        virtual ~HTTPServer();
        
        bool init(int port);
        void ledinit(void);
        int findstr(char *progstr,char* str,int len);
        int ButtonState_str(char* str_Led, unsigned char button);
        int LedState_str(char* str_Led, unsigned char Red, unsigned char Green, unsigned char Blue);
        //void PressButton0(void);
        //void PressButton1(void);
        void run();
        
        void add_request_handler(char *name, RequestHandler* handler);
        
    private :

        void handle_request(char *buffer);
        
        TCPSocketServer socket;
        std::map<char*, RequestHandler*, bool(*)(char*, char*)> handlers;
        char reply[RPC_MAX_STRING];
        int flagHTTP;
        RPCCommand command;
};

#endif

