#include "mbed.h"
#include "nRF24L01P.h"
#define IWDG_START 0x0000CCCC
#define IWDG_WRITE_ACCESS 0x00005555
#define IWDG_PR_PR_0 7
#define IWDG_RELOAD 200000
#define IWDG_REFRESH 0xAAAA
DigitalOut vcc_funk(PB_8);                   // Pin vcc funk modul
#define TRANSFER_SIZE   2



int main()
{       
    //              pLATHALTER FÜR ANSHCALTEN ÜBER GPIO
        //
    vcc_funk = 1;
    wait_us(30);
    nRF24L01P my_nrf24l01p(PB_5,PB_4,PB_3,PB_7,PD_2,PB_6);    // mosi, miso, sck, csn, ce, irq

    char txData[TRANSFER_SIZE];
    int txDataCnt = 0;

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setAirDataRate(250);
    my_nrf24l01p.setTxAddress(0xE7E7E7E7E1,5);
    my_nrf24l01p.setRxAddress(0xE7E7E7E7E7,5,0);
  

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setTransmitMode();
    my_nrf24l01p.enable();
    txData[1] = 2;
    txData[0] = 23;
    txDataCnt =1;
    IWDG->KR=IWDG_START;
    IWDG->KR=IWDG_WRITE_ACCESS;
    IWDG->PR=IWDG_PR_PR_0;
    IWDG->RLR=IWDG_RELOAD;
    while(IWDG->SR) {
        wait_ms(1);
    }
    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
    IWDG->KR=IWDG_REFRESH; /* (6) */
    deepsleep();
    while (1) {
    }
}
