#include "mbed.h"

#define IWDG_START 0x0000CCCC
#define IWDG_WRITE_ACCESS 0x00005555
#define IWDG_PR_PR_0 7
#define IWDG_RELOAD 512*60
#define IWDG_REFRESH 0xAAAA
DigitalOut myled(LED1);
#include "nRF24L01P.h"
DigitalOut pwr(D2);
Serial pc(USBTX, USBRX); // tx, rx
#define TRANSFER_SIZE   1
int main()
{
    pwr = 1;
    wait(2);
    nRF24L01P my_nrf24l01p(D4,D5,D3,D10,D8,D9);    // mosi, miso, sck, csn, ce, irq

    char txData[TRANSFER_SIZE];
    int txDataCnt = 0;
    txData[0] = 2;
    txDataCnt = 2;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setAirDataRate(250);
    my_nrf24l01p.setTxAddress(0xE7E7E7E7E1,5);
    my_nrf24l01p.setRxAddress(0xE7E7E7E7E7,5,0);

#ifdef DEBUG
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
#endif
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setTransmitMode();
    my_nrf24l01p.enable();
#ifdef DEBUG
    IWDG->KR=IWDG_START;
    wait(5);
    IWDG->KR=IWDG_WRITE_ACCESS;
    IWDG->PR=IWDG_PR_PR_0;
    IWDG->RLR=IWDG_RELOAD;
    while(IWDG->SR) {
        wait(0.1);
    }
    pc.printf("Starte");
    pc.printf("sende");
    pc.printf("%d",txData[0]);
#endif
    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
    IWDG->KR=IWDG_REFRESH;
    deepsleep();


}

