#include "mbed.h"
#include "TextLCD.h"
#define VMAX 0.36f
#define VMIN 0.05f
#define AVGNUM 20


Serial  pc(USBTX, USBRX, 115200);

Ticker  ticker1;

CAN     can1(PB_8, PB_9); 
CANMessage  can_msg_1;
CANMessage  can_msg_send;
char data_msg[3] = {0x11,0x22,0x33};

DigitalIn armSwitch(PF_7, PullDown);
bool armed = false;

AnalogIn   res(PA_0);
float volt[AVGNUM];
float voltAVG = 0;
int index = 0;


//I2C i2c_lcd(D14,D15); // SDA, SCL
I2C i2c_lcd(PF_0,PF_1); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x27, TextLCD::LCD16x2); // I2C bus, PCF8574 Slaveaddress, LCD Type

const char fill[] = {0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x00};
const char empty[] = {0x1F, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1F, 0x00};
const char cross[] = {0x00, 0x11, 0x0A, 0x04, 0x0A, 0x11, 0x00, 0x00};

void showBar(void);

void showArm(void);

void CAN_RX1(void);

void sendCMD(void)
{
    if(armed)
    {
        int CMD = 90 * (voltAVG-VMIN)/(VMAX-VMIN);
        if (CMD > 90)
            CMD = 90;
        else if (CMD < 0)
            CMD = 0;
        data_msg[0] = (char)CMD;
        data_msg[1] = (char)CMD;
        data_msg[2] = (char)CMD;
        can_msg_send = CANMessage(0x000,data_msg,3,CANData,CANStandard);
        can1.write(can_msg_send); 
    }
    else
    {
        data_msg[0] = 0;
        data_msg[1] = 0;
        data_msg[2] = 0;
        can_msg_send = CANMessage(0x000,data_msg,3,CANData,CANStandard);
        can1.write(can_msg_send); 
    }
    
    //printf("res: %f\n", voltAVG);
}

int main()
{

    can1.frequency(500000);
    can1.attach(&CAN_RX1, CAN::RxIrq);
    ticker1.attach(&sendCMD, 1);
    pc.printf("start\n");
    
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    lcd.setBacklight(TextLCD::LightOn); 
    lcd.setUDC(0, (char *) fill);
    lcd.setUDC(1, (char *) empty);
    lcd.setUDC(2, (char *) cross);
    pc.printf("set done\n\r");
    
    for(int i = 0; i<AVGNUM; i++)
    {
        volt[i] = 0;   
    }
    
    while(1)
    {   
        volt[index] = res.read();
        index++;
        if (index>=AVGNUM)
            index = 0;
          
        float tmp = 0;  
        for(int i = 0; i<AVGNUM; i++)
        {
          tmp = tmp + volt[i];   
        } 
        voltAVG = tmp/AVGNUM;
        
        
        showBar();
        showArm();
    }

}



void CAN_RX1(void)
{
    if(can1.read(can_msg_1)) 
    {
        pc.printf("CAN RX %d\n", can_msg_1.id);

    }
}

void showBar(void)
{
    int bars = 16 * (voltAVG-VMIN)/(VMAX-VMIN);    
    if (bars > 16)
        bars = 16;
    else if( bars < 0 )
        bars = 0; 
        
    if (armed)
    {
        for(int i = 0; i<bars ;i++)
        {
            lcd.locate(i,0);
            lcd.putc(0);    
        }
        for(int i = bars; i<16 ;i++)
        {
            lcd.locate(i,0);
            lcd.putc(1);    
        }    
    }    
    else
    {
        for(int i = 0; i<bars ;i++)
        {
            lcd.locate(i,0);
            lcd.putc(2);    
        }
        for(int i = bars; i<16 ;i++)
        {
            lcd.locate(i,0);
            lcd.putc(1);    
        } 
    }
}

void showArm(void)
{
    if (armSwitch)
        armed = true;
    else
        armed = false;
    
    if (armed)
    {
        lcd.locate(0,1);
        lcd.printf("ARMED   ");
    }
    else
    {
        lcd.locate(0,1);
        lcd.printf("DISARMED");
    }
        
}
