#include "Interface.hpp"          //Include the header file, this acts like a series of forward declarations 
//Constructor
INTERFACE::INTERFACE(){}//Set all values to 0 
INTERFACE::~INTERFACE(){}   //Destructor
void INTERFACE::Interface_Init(int turns)//Set all values to 0 bar the default turns
{
    Led_Select_Left_mutex.lock();
    Led_Select_Left = 0;
    Led_Select_Left_mutex.unlock();
        
    Led_Select_Right_mutex.lock();
    Led_Select_Right= 0;
    Led_Select_Right_mutex.unlock();
    
    _Twist_Go_mutex.lock();
    _Twist_Go =0;
    _Twist_Go_mutex.unlock();
    
    _Anneal_Go_mutex.lock();
    _Anneal_Go =0;
    _Anneal_Go_mutex.unlock();
    
    _Test_Go_mutex.lock();
    _Test_Go =0;
    _Test_Go_mutex.unlock();
    
    _Select_mutex.lock();
    _Select =0;
    _Select_mutex.unlock();
    
    _Turns_Done_mutex.lock();
    _Turns_Done =0;
    _Turns_Done_mutex.unlock();
    
    _Loop_mutex.lock();
    _Loop =6;
    _Loop_mutex.unlock();
    
    _Loops_done_mutex.lock();
    _Loops_done = 0;
    _Loops_done_mutex.unlock();
    
    _On_Time_mutex.lock();
    _On_Time =4;
    _On_Time_mutex.unlock();
    
    _Off_Time_mutex.lock();
    _Off_Time =9;
    _Off_Time_mutex.unlock();
    
    _Duty_Cycle_mutex.lock();
    _Duty_Cycle =0;
    _Duty_Cycle_mutex.unlock();
    
    _Power_Time_mutex.lock();
    _Power_Time =0;
    _Power_Time_mutex.unlock();
    
     Led_Select_Left_mutex.lock();
     Led_Select_Left = 0;
     Led_Select_Left_mutex.unlock();
     
     Led_Select_Right_mutex.lock();
     Led_Select_Right= 0;
     Led_Select_Right_mutex.unlock();
     
     Led_Power_mutex.lock();
     Led_Power =0;
     Led_Power_mutex.unlock();
     
     _System_Running_mutex.lock();
     _System_Running =0;
     _System_Running_mutex.unlock();
     
     
     Led_Select_Left_mutex.lock();
     Led_Select_Left = 0;
     Led_Select_Left_mutex.unlock();
        
     Led_Select_Right_mutex.lock();
     Led_Select_Right= 1;
     Led_Select_Right_mutex.unlock();
     
     _Turns_Todo_mutex.lock();
     _Turns_Todo = turns;
     _Turns_Todo_mutex.unlock();

     
     _Function_mutex.lock();
     _Function = 0;
     _Function_mutex.unlock();
}

void INTERFACE::Interface_Serial()
{
    printf("Testing\n");
    Thread::wait(1000);
}
void INTERFACE::Up()//Up Routine
{
    if (_Function == 2)//Coiling
    {
        if(_Select == 0)
        {
            _Turns_Todo_mutex.lock();
            _Turns_Todo = _Turns_Todo +1;              
            _Turns_Todo_mutex.unlock();
        }
        else if(_Select == 1)
        {
            _Direction = !_Direction;
        }
    }
    else if (_Function == 3)//Run Once
    {
        if(_On_Time > 0)
        {
            _On_Time_mutex.lock();
            _On_Time =  _On_Time+ 0.5f;  //Increments On time
            _On_Time_mutex.unlock();
        }
    }
    else if (_Function == 0)//Annealing Function
    {
        if (_Select == 0)//Select = 0
        {   
            if(_On_Time > 0)
            {
                _On_Time_mutex.lock();
                _On_Time =  _On_Time+ 0.5f;  //Increments On time
                _On_Time_mutex.unlock();
            }
        }
        else if (_Select == 1)//Select = 1
        {
            if(_Loop > 0)
            {
                _Loop_mutex.lock();
                _Loop = _Loop + 1;  //Increments Repetitions in Annealing
                _Loop_mutex.unlock();
            }
        }
        else if (_Select == 2)//Select = 2
        {
            if(_Off_Time > 0)
            {
                _Off_Time_mutex.lock();
                _Off_Time = _Off_Time + 1;  //Increments Off time
                _Off_Time_mutex.unlock();
            }
        }
    }
    else if (_Function == 1)//Test Function
    {
        if (_Select == 1)//Select = 1
        {
            if (_Duty_Cycle < 100)
            {
                _Duty_Cycle_mutex.lock();
                _Duty_Cycle = _Duty_Cycle + 10; //Increases Testing Duty Cycle
                _Duty_Cycle_mutex.unlock();
            }
        }
        else if (_Select == 0)//Select = 0
        {
            _Power_Time_mutex.lock();
            _Power_Time = _Power_Time + 1;    //Increases time on
            _Power_Time_mutex.unlock();
        }
    }
}

void INTERFACE::Down()//Down Routine
{
        if(_Function == 3)//Run Once
        {
            if(_On_Time > 0)
            {
                _On_Time_mutex.lock();
                _On_Time =  _On_Time - 0.5f;  //Decrements On time
                _On_Time_mutex.unlock();
            }  
        }
        else if (_Function == 2)//Coiling
        {
            if(_Select == 0)
            {
                _Turns_Todo_mutex.lock();
                _Turns_Todo = _Turns_Todo -1;              
                _Turns_Todo_mutex.unlock();
            }
            else if(_Select == 1)
            {
                _Direction = !_Direction;
            }
        }
        else if (_Function == 0)//Annealing Function
        {
            if (_Select == 0)//Select = 0
            {   
                if(_On_Time > 0)
                {
                    _On_Time_mutex.lock();
                    _On_Time =  _On_Time - 0.5f;  //Decrements On time
                    _On_Time_mutex.unlock();
                }
            }
            else if (_Select == 1)//Select = 1
            {
                if(_Loop > 1)
                {
                    _Loop_mutex.lock();
                    _Loop = _Loop - 1;  //Decrements Repetitions in Annealing
                    _Loop_mutex.unlock();
                }
            }
            else if (_Select == 2)//Select = 2
            {
                if(_Off_Time > 1)
                {
                    _Off_Time_mutex.lock();
                    _Off_Time = _Off_Time - 1;  //Decrements Off time
                    _Off_Time_mutex.unlock();
                }
            }
        }
        else if (_Function == 1)//Test Function
        {  
            if (_Select == 1)//Select = 1
            {
                if (_Duty_Cycle > 0)
                {
                     _Duty_Cycle_mutex.lock();
                     _Duty_Cycle = _Duty_Cycle - 10;     //Decreases duty
                     _Duty_Cycle_mutex.unlock();
                }
            }
            else if (_Select == 0)//Select = 0
            {
                if (_Power_Time > 0)
                {
                    _Power_Time_mutex.lock();
                    _Power_Time = _Power_Time - 1;    //Decreases Time on
                    _Power_Time_mutex.unlock();
                }
            }
        }
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void INTERFACE::Start_Stop()//Start / Stop Routine
{
    /*
    System Running = 0 Stop
    System Running = 1 Running
    System Running = 2 Paused
    */
    
    printf("Function is: %d, System is: %d\n",_Function,_System_Running);//Used for debugging
    
    //Start Cases for when the system is stopped///////////////////////////////////////////////////////////////////////////////////
    if((_Function == 3) & _System_Running == 0)//Run Once selected
    {
        _System_Running_mutex.lock();
        _System_Running = 1;//Code is running
        _System_Running_mutex.unlock();
        
        _Run_Go_mutex.lock();
        _Run_Go = true;//Run the run once code
        _Run_Go_mutex.unlock();
    }
    
    else if ((_Function == 2) & _System_Running == 0)//Coiling selected
    {
        _System_Running_mutex.lock();
        _System_Running = 1;//Code is running
        _System_Running_mutex.unlock();
        
        _Twist_Go_mutex.lock();
        _Twist_Go = true;//toggle used for coiling and twisting and Running the code
        _Twist_Go_mutex.unlock();
        
    }
    else if (_Function == 0 & _System_Running == 0) //Annealing selected 
    {
        _System_Running_mutex.lock();
        _System_Running = 1;//Code is running
        _System_Running_mutex.unlock();
        
        _Anneal_Go_mutex.lock();
        _Anneal_Go = true;//toggle and Run the code
        _Anneal_Go_mutex.unlock();
        
        _Loops_done_mutex.lock();
        _Loops_done = 0;
        _Loops_done_mutex.unlock();
    }
    else if (_Function == 1 & _System_Running == 0) //Testing selected 
    {
        _System_Running_mutex.lock();
        _System_Running = 1;//Code is running
        _System_Running_mutex.unlock();
        
        _Test_Go_mutex.lock();
        _Test_Go = true;//toggle and run the code
        _Test_Go_mutex.unlock();
    }
    ///////////////////////////////////////
    
    //System Running cases run to pause the code
    else if((_Function == 3) & _System_Running == 1)//Run once code
    {
        _Run_Stop_mutex.lock();
        _Run_Stop = true;
        _Run_Stop_mutex.unlock();
        _System_Running_mutex.lock();
        _System_Running = 2;
        _System_Running_mutex.unlock(); 
    }
    else if ((_Function == 2) & _System_Running == 1)//Coiling
    {
        _Twist_Stop_mutex.lock();
        _Twist_Stop = true;
        _Twist_Stop_mutex.unlock();
  
        printf("Coiling Code Paused\n");
        _System_Running_mutex.lock();
        _System_Running = 2;
        _System_Running_mutex.unlock();
        STEPPER_MOTOR_1.Pause_Code();
    }
    else if (_Function == 0 & _System_Running == 1) //Annealing selected to be stopped
    {
        _Anneal_Stop_mutex.lock();
        _Anneal_Stop = true;
        _Anneal_Stop_mutex.unlock();
        printf("Annealing Code Paused\n");
        _System_Running_mutex.lock();
        _System_Running = 2;//Pause code
        _System_Running_mutex.unlock();
    }
    else if (_Function == 1 & _System_Running == 1) //Testing selected to be paused
    {
        _Test_Stop_mutex.lock();
        _Test_Stop = true;
        _Test_Stop_mutex.unlock();
        
        printf("Testing Code Paused\n");
        
        
        
        _System_Running_mutex.lock();
        _System_Running = 2;//Pause code
        _System_Running_mutex.unlock();
    }
    
    ////////////////
    //System Paused cases run to unpause
    else if ((_Function == 3) & _System_Running ==2)
    {
        _Run_Stop_mutex.lock();
        _Run_Stop = false;
        _Run_Stop_mutex.unlock();
        
        _Run_Go_mutex.lock();
        _Run_Go = true;//toggle used for coiling and twisting and Running the code
        _Run_Go_mutex.unlock();


        _System_Running_mutex.lock();
        _System_Running = 1;//Code is unpaused
        _System_Running_mutex.unlock();
        
    }
    else if ((_Function == 2) & _System_Running == 2)//Coil to be unpaused
    {
        _Twist_Stop_mutex.lock();
        _Twist_Stop = false;
        _Twist_Stop_mutex.unlock();
        
        _Twist_Go_mutex.lock();
        _Twist_Go = true;//toggle used for coiling and twisting and Running the code
        _Twist_Go_mutex.unlock();
        
        STEPPER_MOTOR_1.Unpause_Code();
            

        printf("Coiling Code unpaused\n");

        _System_Running_mutex.lock();
        _System_Running = 1;//Code is unpaused
        _System_Running_mutex.unlock();
    }
    else if (_Function == 0 & _System_Running == 2) //Annealing selected to be unpaused
    {
        _Anneal_Stop_mutex.lock();
        _Anneal_Stop = false;
        _Anneal_Stop_mutex.unlock();
        printf("Annealing Code unpaused\n");
        
        _Anneal_Go_mutex.lock();
        _Anneal_Go = true;//toggle and Run the code
        _Anneal_Go_mutex.unlock();
        _System_Running_mutex.lock();
        _System_Running = 1;//Code is unpaused
        _System_Running_mutex.unlock();
    }
    else if (_Function == 1 & _System_Running == 2) //Testing selected to be re run
    {
        _Test_Stop_mutex.lock();
        _Test_Stop = false;
        _Test_Stop_mutex.unlock();
        printf("Testing Code unpaused\n");
        _Test_Go_mutex.lock();
        _Test_Go = true;//toggle and run the code
        _Test_Go_mutex.unlock();
        _System_Running_mutex.lock();
        _System_Running = 1;//Code is unpaused
        _System_Running_mutex.unlock();
    }
}
void INTERFACE::Function()//Function Routine used to increment through the three functions
{
    /*
    Function 0 = Anneal
    Function 1 = Test
    Function 2 = Coiling
    Function 3 = Run Once
    */
    _Select_mutex.lock();
    _Select = 0;//Set the select value to 0 whenever the function is changed
    _Select_mutex.unlock();

    if(_Function < 3)
    {
        _Function_mutex.lock();
        _Function = _Function + 1;  
        _Function_mutex.unlock(); 
    }
    else if(_Function == 3)
    {
        _Function = 0;   
    }
}
void INTERFACE::Select()//Select Routine
{
    _Select_mutex.lock();
    if(_Function == 0)//Anneal
    {
        printf("Select Value is :%d\n",_Select);
        if(_Select == 2)
        {
            _Select = 0;
        }
        else if(_Select == 1)
        {
            _Select = 2;
        }
        else if(_Select == 0)
        {
            _Select = 1;
        }
        if(_Select == 0 || _Select == 2)
        {
            Led_Select_Left_mutex.lock();
            Led_Select_Left = 0;
            Led_Select_Left_mutex.unlock();
            
            Led_Select_Right_mutex.lock();
            Led_Select_Right= 1;
            Led_Select_Right_mutex.unlock();    
        }
        else if(_Select == 1)
        {
            Led_Select_Left_mutex.lock();
            Led_Select_Left = 1;
            Led_Select_Left_mutex.unlock();
            
            Led_Select_Right_mutex.lock();
            Led_Select_Right= 0;
            Led_Select_Right_mutex.unlock();   
        }
        printf("Select Value is :%d\n",_Select);
    }
    else if(_Function == 1)//Test
    {
        if(_Select == 0)
        {
            _Select = 1;
        }
        else if(_Select == 1)
        {
            _Select = 0;  
        }
        
        if(_Select == 0)
        {
            Led_Select_Left_mutex.lock();
            Led_Select_Left = 0;
            Led_Select_Left_mutex.unlock();
            
            Led_Select_Right_mutex.lock();
            Led_Select_Right= 1;
            Led_Select_Right_mutex.unlock();
        }
        else if(_Select ==1)
        {
            Led_Select_Left_mutex.lock();
            Led_Select_Left = 1;
            Led_Select_Left_mutex.unlock();
            
            Led_Select_Right_mutex.lock();
            Led_Select_Right= 0;
            Led_Select_Right_mutex.unlock();   
        }
    }
    else if(_Function == 2 )//Coiling 
    {
        if(_Select == 0)//Toggle code for select
        {
            _Select = 1;
        }
        else if(_Select == 1)
        {
            _Select = 0;  
        }
        
        if(_Select == 0)
        {
            Led_Select_Left_mutex.lock();
            Led_Select_Left = 0;
            Led_Select_Left_mutex.unlock();
            
            Led_Select_Right_mutex.lock();
            Led_Select_Right= 1;
            Led_Select_Right_mutex.unlock();
        }
        else if(_Select == 1)
        {
            Led_Select_Left_mutex.lock();
            Led_Select_Left = 1;
            Led_Select_Left_mutex.unlock();
            
            Led_Select_Right_mutex.lock();
            Led_Select_Right= 0;
            Led_Select_Right_mutex.unlock();   
        }
    }
    else if(_Function == 3)//Run once code alway have the led to be on the left
    {
        Led_Select_Left_mutex.lock();
        Led_Select_Left = 0;
        Led_Select_Left_mutex.unlock();
            
        Led_Select_Right_mutex.lock();
        Led_Select_Right= 1;
        Led_Select_Right_mutex.unlock();     
    }
    _Select_mutex.unlock();
}
void INTERFACE::Interface_main()//Main Routine to execute commands when the start button has been pressed
{
    if (_Function == 3)  //Run once code Code
    {
        if (_Run_Go == true)
        {
            Led_Power_mutex.lock();
            Led_Power = 1;
            Led_Power_mutex.unlock();
            
            _System_Running_mutex.lock();
            _System_Running = 1;
            _System_Running_mutex.unlock();
            
           
            if(_System_Running == 1)
            {
               
                _Run_Once_On_Time_mutex.lock();
                Thread::wait((_Run_Once_On_Time)*1000);//Variable
                _Run_Once_On_Time_mutex.unlock();
    
                Thread::wait(9001);//Fixed off time ITS OVER 9000
                _Tendon_mutex.unlock();
            }
            while(_System_Running == 2)//Stops the system and just spins in this while loop until system running is not paused
            {
                _Tendon_mutex.lock();
    
                _Tendon_mutex.unlock();
            }
            
            _System_Running_mutex.lock();
            _System_Running = 0;
            _System_Running_mutex.unlock();
               
            _Run_Go_mutex.lock();
            _Run_Go = false;
            _Run_Go_mutex.unlock();
            
            Led_Power_mutex.lock();
            Led_Power = 0;
            Led_Power_mutex.unlock();
        }
    }
    else if (_Function == 2)       //Turning Code for coiling
    {
        if (_Twist_Go == true)
        {
            Led_Power_mutex.lock();
            Led_Power = 1;
            Led_Power_mutex.unlock();
            
            _System_Running_mutex.lock();
            _System_Running = 1;
            _System_Running_mutex.unlock();
            
            STEPPER_MOTOR_1.Rotate_Steps(_Turns_Todo,_Function,_Direction);//Rotates for the specified number of steps given
            
            _System_Running_mutex.lock();
            _System_Running = 0;
            _System_Running_mutex.unlock();
            
            
            _Twist_Go_mutex.lock();
            _Twist_Go = false;
            _Twist_Go_mutex.unlock();
            
            Led_Power_mutex.lock();
            Led_Power = 0;
            Led_Power_mutex.unlock();
        }
    }
    else if (_Function == 0)  //Annealing Code
    {
        if (_Anneal_Go == true)
        {
            Led_Power_mutex.lock();
            Led_Power = 1;
            Led_Power_mutex.unlock();
            
            _System_Running_mutex.lock();
            _System_Running = 1;
            _System_Running_mutex.unlock();
            
            _Loops_done_mutex.lock();
            _Loops_done = 0;
            _Loops_done_mutex.unlock();
            
            for ( int counter = 0; counter < _Loop; counter++)  //Loop value, check if works
            {
                if(_System_Running == 1)
                {
                    _Tendon_mutex.lock();
                    
                    _On_Time_mutex.lock();
                    Thread::wait((_On_Time)*1000);//Variable
                    _On_Time_mutex.unlock();
                    
                    _Off_Time_mutex.lock();
                    Thread::wait((_Off_Time)*1000);//Fixed off time
                    _Off_Time_mutex.unlock();
                    _Tendon_mutex.unlock();
                }
                while(_System_Running == 2)//Stops the system and just spins in this while loop until system running is not paused
                {
                    
                }
                _Loops_done_mutex.lock();
                _Loops_done = _Loops_done + 1;
                _Loops_done_mutex.unlock();
            }
            
            _System_Running_mutex.lock();
            _System_Running = 0;
            _System_Running_mutex.unlock();
               
            _Anneal_Go_mutex.lock();
            _Anneal_Go = false;
            _Anneal_Go_mutex.unlock();
            
            Led_Power_mutex.lock();
            Led_Power = 0;
            Led_Power_mutex.unlock();
        }
    }
    else if (_Function == 1)  //Testing Code //This code is paused / unpaused in start / stop note this code is not paused it is re run.
    {
        if (_Test_Go == true)
        {
            Led_Power_mutex.lock();
            Led_Power = 1;
            Led_Power_mutex.unlock();
            
            _System_Running_mutex.lock();
            _System_Running = 1;
            _System_Running_mutex.unlock();
            
            _Tendon_mutex.lock();
            Thread::wait((_Power_Time)*1000);//Variable on time for power on
        
            _Tendon_mutex.unlock();
            
            _System_Running_mutex.lock();
            _System_Running = 0;
            _System_Running_mutex.unlock();
            
            _Test_Go_mutex.lock();
            _Test_Go = false;
            _Test_Go_mutex.unlock();
            
            Led_Power_mutex.lock();
            Led_Power = 0;
            Led_Power_mutex.unlock();
        }
    }
}
//Setter functions
void INTERFACE::Set_System_Running(int System_Running){_System_Running_mutex.lock(); _System_Running = System_Running; _System_Running_mutex.unlock();}
void INTERFACE::Set_Function(int Function){_Function_mutex.lock();_Function = Function;_Function_mutex.unlock();}
void INTERFACE::Set_Twist_Go(bool Twist_Go){_Twist_Go_mutex.lock();_Twist_Go = Twist_Go;_Twist_Go_mutex.unlock();}
void INTERFACE::Set_Anneal_Go(bool Anneal_Go){_Anneal_Go_mutex.lock();_Anneal_Go = Anneal_Go;_Anneal_Go_mutex.unlock();}
void INTERFACE::Set_Test_Go(bool Test_Go){_Test_Go_mutex.lock();_Test_Go = Test_Go;_Test_Go_mutex.unlock();}
void INTERFACE::Set_Run_Go(bool Run_Go){_Run_Go_mutex.lock();_Run_Go = Run_Go;_Run_Go_mutex.unlock();}
void INTERFACE::Set_Twist_Stop(bool Twist_Stop){_Twist_Stop_mutex.lock();_Twist_Stop = Twist_Stop;_Twist_Stop_mutex.unlock();}
void INTERFACE::Set_Anneal_Stop(bool Anneal_Stop){_Anneal_Stop_mutex.lock();_Anneal_Stop = Anneal_Stop;_Anneal_Stop_mutex.unlock();}
void INTERFACE::Set_Test_Stop(bool Test_Stop){_Test_Stop_mutex.lock();_Test_Go = Test_Stop;_Test_Stop_mutex.unlock();}
void INTERFACE::Set_Run_Stop(bool Run_Stop){_Run_Stop_mutex.lock();_Run_Stop = Run_Stop;_Run_Stop_mutex.unlock();}
void INTERFACE::Set_Select(int Select){_Select_mutex.lock();_Select = Select;_Select_mutex.unlock();}
void INTERFACE::Set_Turns_Done(int Turns_Done){_Turns_Done_mutex.lock();_Turns_Done = Turns_Done;_Turns_Done_mutex.unlock();}
void INTERFACE::Set_Turns_To_Do(int Turns_Todo){_Turns_Todo_mutex.lock();_Turns_Todo = Turns_Todo;_Turns_Todo_mutex.unlock();}
void INTERFACE::Set_Loop(int Loop){_Loop_mutex.lock();Loop = Loop;_Loop_mutex.unlock();}
void INTERFACE::Set_Loops_done(int Loops_done){_Loops_done_mutex.lock();_Loops_done = Loops_done; _Loops_done_mutex.unlock();}
void INTERFACE::Set_On_Time(float On_Time){_On_Time_mutex.lock();_On_Time = On_Time;_On_Time_mutex.unlock();}
void INTERFACE::Set_Run_Once_On_Time(float Run_Once_On_Time){_Run_Once_On_Time_mutex.lock();_Run_Once_On_Time = Run_Once_On_Time;_Run_Once_On_Time_mutex.unlock();}
void INTERFACE::Set_Off_Time(int Off_Time){_Off_Time_mutex.lock();_Off_Time = Off_Time;_Off_Time_mutex.unlock();}
void INTERFACE::Set_Duty_Cycle(int Duty_Cycle){_Duty_Cycle_mutex.lock();_Duty_Cycle = Duty_Cycle;_Duty_Cycle_mutex.unlock();}
void INTERFACE::Set_Power_Time(float Power_Time){_Power_Time_mutex.lock();_Power_Time = Power_Time;_Power_Time_mutex.unlock();} 
void INTERFACE::Set_Direction(bool Direction){_Direction_mutex.lock();_Direction = Direction;_Direction_mutex.unlock();}
//Getter functions
int INTERFACE::Get_System_Running(){return _System_Running;}
int  INTERFACE::Get_Function(){return _Function;}
bool INTERFACE::Get_Twist_Go(){return _Twist_Go;}
bool INTERFACE::Get_Anneal_Go(){return _Anneal_Go;}
bool INTERFACE::Get_Test_Go(){return _Test_Go;}
bool INTERFACE::Get_Run_Go(){return _Run_Go;}
bool INTERFACE::Get_Twist_Stop(){return _Twist_Stop;}
bool INTERFACE::Get_Anneal_Stop(){return _Anneal_Stop;}
bool INTERFACE::Get_Test_Stop(){return _Test_Stop;}
bool INTERFACE::Get_Run_Stop(){return _Run_Stop;}
int INTERFACE::Get_Select(){return _Select;}
int INTERFACE::Get_Turns_Done(){_Turns_Done = STEPPER_MOTOR_1.Get_Turns(); return _Turns_Done;}
int INTERFACE::Get_Turns_To_Do(){return _Turns_Todo;}
int INTERFACE::Get_Loops_done(){return _Loops_done;}
int INTERFACE::Get_Loop(){return _Loop;}
float INTERFACE::Get_On_Time(){return _On_Time;}
float INTERFACE::Get_Run_Once_On_Time(){return _Run_Once_On_Time;}
int INTERFACE::Get_Off_Time(){return _Off_Time;}
int INTERFACE::Get_Duty_Cycle(){return _Duty_Cycle;}
int INTERFACE::Get_Power_Time(){return _Power_Time;}
bool INTERFACE::Get_Direction(){return _Direction;}