#include "TIME.hpp"


using namespace std;

Mutex Time_Lock;                    //Declare MUTEX

int current_time_global = 0;        //Declare required variable
int new_time = 0;                   //Declare required variable

int get_current_time()              //Get Current Time
{
    Time_Lock.lock();               //Apply MUTEX lock
    current_time_global = time(0);  //Get current time
    Time_Lock.unlock();             //Release MUTEX lock
    return current_time_global;     //Return the current time
}

void set_new_date(int days, int months, int years)                                                      //Set new date
{
    Time_Lock.lock();                                                                                   //Apply MUTEX lock
    time_t Time = time(NULL);                                                                           //Get system time
    Time_Lock.unlock();                                                                                 //Release MUTEX lock                                                                         
    tm* Time_Pointer = localtime(&Time);                                                                //Create pointer to Time
    set_time(get_current_time() - year*(Time_Pointer->tm_year - 70) + year*(years - 1970));             //Set the year     
    set_time(get_current_time() - month*Time_Pointer->tm_mon + month*(months - 1));                     //Set the month
    set_time(get_current_time() - day*Time_Pointer->tm_mday + day*days);                                //Set the day
}

void set_new_time(int hours, int minutes, int seconds)                                                  //Set new time
{
    Time_Lock.lock();                                                                                   //Apply MUTEX lock
    time_t Time = time(NULL);                                                                           //Get system time
    Time_Lock.unlock();                                                                                 //Release MUTEX lock
    tm* Time_Pointer = localtime(&Time);                                                                //Create pointer to Time 
    set_time(get_current_time() - second*Time_Pointer->tm_sec + second*seconds);                        //Set the second
    set_time(get_current_time() - minute*Time_Pointer->tm_min + minute*minutes);                        //Set the minute
    set_time(get_current_time() - hour*Time_Pointer->tm_hour + hour*hours);                             //Set the hour
}

void Add_Second()                   //Add one second to current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) + 1;         //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Subtract_Second()              //Subtract one second from current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) - 1;         //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time   
}

void Add_Minute()                   //Add one minute to the current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) + 60;        //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Subtract_Minute()              //Subtract one minute from current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) - 60;        //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
    
}

void Add_Hour()                     //Add one hour to the current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) + 3600;      //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Subtract_Hour()                //Subtract one hour from the current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) - 3600;      //Calculate new time  
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Add_Day()                      //Add one day to the current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) + 86400;     //Calculate new time 
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Subtract_Day()                 //Subtract one day from the current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) - 86400;     //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Add_Month()                    //Add one month to current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) + 2629743;   //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Subtract_Month()               //Subtract one month from current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) - 2629743;   //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Add_Year()                     //Add one year to current time
{
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) + 31556926;  //Calculate new time
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}

void Subtract_Year()                //Subtract one year from current time
{   
    Time_Lock.lock();               //Apply MUTEX lock
    new_time = time(0) - 31556926;  //Calculate new time  
    Time_Lock.unlock();             //Release MUTEX lock
    set_time(new_time);             //Set new time
}
