/*
This is the ALGORITHM class and it will be used tgo determine the move sequence the motors need to enact upon.
*/

#ifndef ALGORITHM_HPP//Header Guards Prevents Multiple includes
#define ALGORITHM_HPP

//Libraries and header includes
#include "THREADS.hpp"
#include "mbed.h"
#include "rtos.h"
#include "SERIAL.hpp"
#include "COLOURS.hpp"

enum Colours//The posible colours of each point on the cube map
{
    White,//Front
    Red,//Upper
    Orange,//Down
    Blue,//Left
    Green,//Right
    Yellow//Back   
};
static Colours CubeMap[6][3][3];//The colours of each section on the cube map

enum Moves//This is an enumeration of the different tpyes of moves which will be avalible
{
       CL,AL,
       CF,AF,
       CR,AR,
       CB,AB,
       CU,AU,
       CD,AD
       
};
class ALGORITHM                       //This creates a class called Led
{ 
public: 
    
    ALGORITHM(); //Constructor
    ~ALGORITHM();//Destructor
    void ALGORITHM_INIT();
    void Find_edges();//Sets the internal variable to the location of all the pieces and the positions of them
    void Find_Corners();//Finds the corners with the colour that is passed into them
private:    
    //Private member variables to prevent them being accessed externally 
    //Data Pins
    int _State;
    //Pointers to the lists elements
    int _White_Pointer_Edge;
    int _Orange_Pointer_Edge;
    int _Blue_Pointer_Edge;
    int _Red_Pointer_Edge;
    int _Green_Pointer_Edge;
    int _Yellow_Pointer_Edge;
    
    int _White_Pointer_Corner;
    int _Orange_Pointer_Corner;
    int _Blue_Pointer_Corner;
    int _Red_Pointer_Corner;
    int _Green_Pointer_Corner;
    int _Yellow_Pointer_Corner;    
    //Lists with the positions of the colours
    int _White_List_Edge[4];
    int _Orange_List_Edge[4];
    int _Blue_List_Edge[4];
    int _Red_List_Edge[4];
    int _Green_List_Edge[4];
    int _Yellow_List_Edge[4];
    
    int _White_List_Corner[4];
    int _Orange_List_Corner[4];
    int _Blue_List_Corner[4];
    int _Red_List_Corner[4];
    int _Green_List_Corner[4];
    int _Yellow_List_Corner[4];


    //Private member functions
    void _Find_edges_White();//Identify White edges
    void _Find_Corners_White();//Identify White edges
    void _Find_edges_Orange();//Identify White edges
    void _Find_Corners_Orange();//Identify White edges
    void _Find_edges_Blue();//Identify White edges
    void _Find_Corners_Blue();//Identify White edges
    void _Find_edges_Red();//Identify White edges
    void _Find_Corners_Red();//Identify White edges
    void _Find_edges_Green();//Identify White edges
    void _Find_Corners_Green();//Identify White edges
    void _Find_edges_Yellow();//Identify White edges
    void _Find_Corners_Yellow();//Identify White edges
};
class SIDE                       //This creates a class called Led
{ 
public: 
    
    SIDE(); //Constructor
    ~SIDE();//Destructor
    int SIDE_type();
    
    void Set_Colours(int CP1,int CP2,int CP3,int CP4,int CP5,int CP6,int CP7,int CP8,int CP9);
private:    
    //Private member variables to prevent them being accessed externally 

    //Positions of the cubelets
    int _Cubelet_1_position;
    int _Cubelet_2_position;
    int _Cubelet_3_position;
    int _Cubelet_4_position;
    int _Cubelet_5_position;
    int _Cubelet_6_position;
    int _Cubelet_7_position;
    int _Cubelet_8_position;
    int _Cubelet_9_position;
    
    int _Cubelet_1_colour;
    int _Cubelet_2_colour;
    int _Cubelet_3_colour;
    int _Cubelet_4_colour;
    int _Cubelet_5_colour;
    int _Cubelet_6_colour;
    int _Cubelet_7_colour;
    int _Cubelet_8_colour;
    int _Cubelet_9_colour;
  
};


#endif//ALGORITHM_HPP