#include "DRIVER.hpp"

int Counter_max = 100;
int Counter = 0;//Value for counting the steps in the sine wave
float Sine_vector[100];
float Returned_Duty_cycle = 0;
#define PI 3.141592653
#define Duty_Cycle_Scaling 1;
//Constructor

DRIVER::DRIVER(PinName N1, PinName N2, PinName N3, PinName N4) : _Pwm_Output(N1),_Control_Pin(N2),_Hall_Effect_Sensor(N3),_Coil_Feedback(N4)
{
    _Pwm_Output.period(0.02f);//Period of 20ms for 50Hz
    _Pwm_Output.write(0.0f);//Duty cycle of 0 for initialisation
}
DRIVER::~DRIVER(){}   //Destructor


//Core Functions
void DRIVER::Test(){printf("Testing driver code\n");}

void DRIVER::Sine_Lookup_Table_Generator()
{
    for(int vector_count = 0; vector_count <= Counter_max; vector_count ++)
    {   
        if(vector_count <= (Counter_max/2))//First half
        {
            Sine_vector[vector_count] = (int)sin(2.0*PI*(float)vector_count/Counter_max);
        }else if(vector_count > (Counter_max/2)){    //Second half
            Sine_vector[vector_count] = (1.0+sin(2.0*PI*vector_count/Counter_max));
        }
    }
}   

void DRIVER::Output_Sine_Wave()
{
    if(Counter < (Counter_max/2))//First half
    {
        _Control_Pin = 0;                       //Control 1 line low
    }
    else if(Counter > (Counter_max/2))     //Second half
    {
        _Control_Pin = 1;                      //Control 1 line high
    }
    Returned_Duty_cycle = Sine_vector[Counter];
    _Pwm_Output.write(Returned_Duty_cycle);
    //returned_duty_cycle = Sine_generator(Counter);//Return the next value to be set in the duty cycle
    Counter = Counter +1 ;//Increment Counter
    //printf("Counter Value is :%d\n",Counter);
    if(Counter == Counter_max)//Reset Statement for when the entire sine wave is completed.
    {
        Counter = 0;//Reset the counter
    }  
}

//Setter Functions    
//void DRIVER::Set_Pwm_Output(float Period, float Duty_Cycle){_Pwm_Output.period(Period); _Pwm_Output.write(Duty_Cycle);}
void DRIVER::Set_Control_Pin(bool Control_Pin){_Control_Pin = Control_Pin;}
//Getter Functions
float DRIVER::Get_Hall_Effect_Sensor_Value(){return _Hall_Effect_Sensor;}
float DRIVER::Get_Coil_Feedback_Value(){return _Coil_Feedback;}