#ifndef _DRIVER__HPP_
#define _DRIVER__HPP_
#include "mbed.h"


//static Serial pc2(USBTX, USBRX);         //Define serial namespace so the serial comms can be printed to
class DRIVER
{ 
    public: 
    
    DRIVER(PinName N1, PinName N2, PinName N3, PinName N4);
    ~DRIVER();
    
    //Core Functions
    
    void Test();
    void Sine_Lookup_Table_Generator();
    void Output_Sine_Wave();
    //Setter Functions    
    //void Set_Pwm_Output(float Period, float Duty_Cycle);
    void Set_Control_Pin(bool Control_Pin);
    //Getter Functions
    float Get_Hall_Effect_Sensor_Value();
    float Get_Coil_Feedback_Value();
    
    
    private://Private member variables to prevent them being accessed externally
    
    PwmOut     _Pwm_Output;
    DigitalOut _Control_Pin;
    AnalogIn   _Hall_Effect_Sensor; 
    AnalogIn   _Coil_Feedback;
    
    //Values of inputs
    
    float _Hall_Effect_Sensor_Value;
    float _Coil_Feedback_Value;         
    //Mutex Locks
};

#endif//_DRIVER_HPP_
/*
    //Output Connections
    PwmOut Pwm_Output(PB_0);// PWM output pin D3 on the board
    DigitalOut Control_Pin(D5);//Control Pin for the board
    //Input Connections
    AnalogIn Hall_Effect_Sensor(PA_0);//Hall Effect Sensor A0 on board
    AnalogIn Coil_Feedback(PA_1);//Coil feedback ADC pin connection A1 on board
*/
