#include "mbed.h"
#include "Led.h"
#include "rtos.h"
#include "TextLCD.h"

//Sets up LCD
Led RedLed(D7);
Led GreenLed(D5);
TextLCD lcd(A0, A1, A2, A3, A4, A5,TextLCD::LCD16x2); // rs, e, d4-d7 
AnalogIn LDR(D11);
float LDR_value = 0;
//Declare Threads
Thread t1;

//Declare Ticker
Ticker sample_interval;
Ticker LED_test;
void LCD_Write(float LDR);
void LDR_Read();
void sampling_ISR();

//Declare Thread IDs
osThreadId tidmain;
osThreadId id1;
void InvertLed()
{
    RedLed.Toggle();   
}
int main() 
{
    GreenLed.switchOff();
    RedLed.switchOn();
    
    
    LDR_value = LDR;
    lcd.printf("LDR Value is %1.1f \n",LDR_value);
    t1.start(LDR_Read);                        //Start LDR Reading Thread
    sample_interval.attach(&sampling_ISR, 1);       //Set the sampling interval to 15 seconds
    LED_test.attach(&InvertLed,1);
    id1 = t1.gettid(); //id of thread
    osSignalSet(id1, true);  
}

void sampling_ISR(){
    t1.signal_set(true); //Set the sampling thread signal to true
}

void LDR_Read(){
    //GreenLed.switchOn();
    while(1){
        osSignalWait(true,osWaitForever);          //Wait until the sampling thread signal is set to true
        GreenLed.switchOn();
        t1.signal_set(false);         //Set the sampling signal thread to false
        LDR_value = LDR;
        LCD_Write(LDR_value);
    }
}

void LCD_Write(float _LDR)
{

    lcd.printf("LDR Value is:   %1.5f \n",_LDR);
}



