#include "sample_hardware.hpp"
#include "Networkbits.hpp"
#include "rtos.h"
#include "LED.hpp"
#define SamplingTime 1
#define NotSamplingTime 0
#define TimerInterval 15 //This is in seconds

Serial pc(USBTX, USBRX);

// This is a very short demo that demonstrates all the hardware used in the coursework.
// You will need a network connection set up (covered elsewhere). The host PC should have the address 10.0.0.1
//Thread ID
osThreadId idMain;
osThreadId id1;
osThreadId id2;
osThreadId id3;
osThreadId id4;

LED Red_led(PE_15);
LED Yellow_led(PB_10);
LED Green_led(PB_11);

Ticker Sample_timer;
//Threads
Thread nwrkThread;
Thread t1;
Thread t2;

void Serial_Comms()//Thread for Serial Communications
{
    pc.printf("Hello World \n");
    while(1)
    {
        pc.printf("Test\n");
        Thread::wait(1000);   
    }
}

void Sample_signal_set()//Sets the Signal for when to sample the sensors
{
    t1.signal_set(SamplingTime);   
}

void Sample()//Samples the hardware and prints the result to the LCD
{
    while(1)
    {     
        Thread::signal_wait(SamplingTime);
        //Read environmental sensors
        double temp = sensor.getTemperature();
        double pressure = sensor.getPressure();
        double lux = adcIn.read();
        //Write new data to LCD (not fast!)
        lcd.cls();
        lcd.printf("Temp Pres  li\n"); 
        lcd.printf("%1.1f ",temp);
        lcd.printf("%1.1f ",pressure);
        lcd.printf("%1.1f\n",lux);
        
        //Write to SD (potentially slow)
        //fprintf(fp, "%6.1f,%.2f\n\r", temp, pressure);
    
        Red_led.Toggle();
        t1.signal_set(NotSamplingTime);
        //Thread::wait(15000);//Time interval
    }
} 

int main() 
{  
    //Greeting
    printf("Testing\n\n");    
    
    pc.baud(9600);//Sets the Serial Comms Baud Rate
    
    post();//Power on Self Test
    
    //Initialise the SD card (this needs to move)
    if ( sd.init() != 0) {
        printf("Init failed \n");
        lcd.cls();
        lcd.printf("CANNOT INIT SD");        
        errorCode(FATAL);
    } 
    
    //Create a filing system for SD Card
    FATFileSystem fs("sd", &sd);     

    //Open to WRITE
    FILE* fp = fopen("/sd/test.csv","a");
    if (fp == NULL) {
        error("Could not open file for write\n");
        lcd.cls();
        lcd.printf("CANNOT OPEN FILE\n\n");
        errorCode(FATAL);
    }
    
    //Last message before sampling begins
    lcd.cls();
    lcd.printf("READY\n\n");
    
    //Run interrupt
    Sample_timer.attach(&Sample_signal_set,TimerInterval);
    
    //Run Threads
    
    
    t1.start(Sample);
    t2.start(Serial_Comms);
    
    //Main thread ID
    
    idMain = osThreadGetId();   //CMSIS RTOS call
    
    //Thread ID
    id1 = t1.gettid();
    id2 = t2.gettid();
    
    
    //Toggle Green LED after a button has been pressed
    //Press either switch to unmount
    while ((SW1 == 0) && (SW2 == 0)) {
    
    }
    
    //Close File
    fclose(fp);
    
    //Close down
    sd.deinit();
    printf("Unmounted...\n");
    lcd.cls();
    lcd.printf("Unmounted...\n\n");
    
    while(true) {
        greenLED = 1;
        wait(0.5);
        greenLED = 0;
        wait(0.1);    
    }
}


    
